/*
 * Decompiled with CFR 0.152.
 */
package adams.optimise;

import adams.core.logging.LoggingLevel;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.env.Environment;
import adams.multiprocess.AbstractJob;
import adams.multiprocess.Job;
import adams.multiprocess.JobList;
import adams.multiprocess.JobWithOwner;
import adams.multiprocess.LocalJobRunner;
import adams.optimise.FitnessFunction;
import adams.optimise.OptData;
import adams.optimise.OptVar;
import adams.optimise.genetic.PackData;
import adams.optimise.genetic.PackDataDef;
import adams.optimise.genetic.PackDataGeneticAlgorithm;
import adams.optimise.genetic.fitnessfunctions.AttributeSelection;
import java.util.Hashtable;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.functions.GPD;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.functions.PLSClassifier;
import weka.classifiers.meta.FilteredClassifier;
import weka.core.SelectedTag;
import weka.filters.Filter;
import weka.filters.MultiFilter;
import weka.filters.supervised.attribute.PLSFilter;
import weka.filters.unsupervised.attribute.Remove;

public class GeneticAlgorithm
extends PackDataGeneticAlgorithm {
    private static final long serialVersionUID = 3050987598416662061L;
    protected int m_bits = 5;
    protected int m_zerocount = Integer.MAX_VALUE;
    protected PackDataDef m_pdd = null;
    protected FitnessFunction m_fitnessfn = null;
    protected Long m_LastNotificationTime;
    public Hashtable<String, Double> m_StoredResults = new Hashtable();

    protected synchronized void addResult(String key, Double val) {
        this.m_StoredResults.put(key, val);
    }

    @Override
    public void reset() {
        super.reset();
        this.m_StoredResults = new Hashtable();
    }

    protected synchronized Double getResult(String key) {
        Double res = this.m_StoredResults.get(key);
        return res;
    }

    protected synchronized void clearResults() {
        this.m_StoredResults.clear();
    }

    public String weightsToString(int[] weights) {
        String ret = "";
        for (int i = 0; i < weights.length; ++i) {
            ret = weights[i] == 0 ? ret + "0" : ret + "1";
        }
        return ret;
    }

    public double calcNewFitness(FitnessFunction ff, int[] weights) {
        Double cc = this.getResult(this.weightsToString(weights));
        if (cc != null) {
            return cc;
        }
        PackData pd = new PackData(this.getDataDef());
        pd.putBits(weights);
        int count = 0;
        for (int i = 0; i < weights.length; ++i) {
            if (weights[i] != 0) continue;
            ++count;
        }
        OptData odd = new OptData();
        for (String var : pd.getKeySet()) {
            odd.set(var, pd.get(var));
        }
        double val = ff.evaluate(odd);
        this.checkBest(val, odd, ff, count);
        odd.cleanUp();
        return val;
    }

    public synchronized void checkBest(Double fitness, OptData vars, FitnessFunction ff, int zerocount) {
        if (fitness > this.m_bestf || fitness == this.m_bestf && zerocount < this.m_zerocount) {
            this.m_zerocount = zerocount;
            this.m_bestf = new Double(fitness);
            if (this.m_bestv != null) {
                this.m_bestv.cleanUp();
            }
            this.m_bestv = vars.getClone();
            ff.newBest(fitness.doubleValue(), vars);
        }
    }

    public String globalInfo() {
        return "Genetic Algorithm.";
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("bits", "bits", (Object)5);
    }

    public void setBits(int value) {
        this.m_bits = value;
    }

    public int getBits() {
        return this.m_bits;
    }

    public String bitsTipText() {
        return "The number of bits to use.";
    }

    @Override
    public void calcFitness() {
        int i;
        LocalJobRunner runner = new LocalJobRunner();
        JobList jobs = new JobList();
        GAJob[] jbs = new GAJob[this.getNumChrom()];
        for (i = 0; i < this.getNumChrom(); ++i) {
            GAJob jb;
            int[] weights = new int[this.getNumGenes()];
            for (int j = 0; j < this.getNumGenes(); ++j) {
                weights[j] = this.getGene(i, j) ? 1 : 0;
            }
            jbs[i] = jb = new GAJob(this, this.m_fitnessfn, weights);
            jobs.add((Job)jb);
        }
        runner.add(jobs);
        runner.start();
        runner.stop();
        for (i = 0; i < this.getNumChrom(); ++i) {
            this.m_Fitness[i] = jbs[i].m_fitness;
        }
    }

    @Override
    protected void preRun() {
        super.preRun();
        this.m_LastNotificationTime = null;
        this.init(this.getNumChrom());
        this.clearResults();
    }

    @Override
    public PackDataDef getDataDef() {
        return this.m_pdd;
    }

    @Override
    public Vector<PackData> getDataSetups() {
        Vector<PackData> vpd = new Vector<PackData>();
        return vpd;
    }

    public OptData optimise(OptData datadef, FitnessFunction fitness) {
        this.m_pdd = new PackDataDef();
        this.m_fitnessfn = fitness;
        for (String var : datadef.getVarNames()) {
            OptVar ov = datadef.getVar(var);
            this.m_pdd.add(var, this.getBits(), ov.m_min, ov.m_max);
        }
        this.run();
        return this.m_bestv;
    }

    public void cleanUp() {
        super.cleanUp();
        this.clearResults();
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        GeneticAlgorithm ga = new GeneticAlgorithm();
        ga.setBits(1);
        ga.setNumChrom(8);
        ga.setIterations(10000);
        ga.setFavorZeroes(true);
        AttributeSelection as = new AttributeSelection();
        ArrayConsumer.setOptions((OptionHandler)as, (String[])args);
        PLSClassifier pls = new PLSClassifier();
        PLSFilter pf = (PLSFilter)pls.getFilter();
        pf.setNumComponents(11);
        LinearRegression reg = new LinearRegression();
        reg.setEliminateColinearAttributes(false);
        reg.setAttributeSelectionMethod(new SelectedTag(1, LinearRegression.TAGS_SELECTION));
        GPD gp = new GPD();
        gp.setNoise(0.01);
        Remove remove = new Remove();
        remove.setAttributeIndices("1");
        FilteredClassifier fc = new FilteredClassifier();
        MultiFilter mf = new MultiFilter();
        Filter[] filters = new Filter[]{remove, pf};
        mf.setFilters(filters);
        fc.setClassifier((Classifier)gp);
        fc.setFilter((Filter)pf);
        as.setClassifier((Classifier)gp);
        as.setClassIndex("last");
        ga.setLoggingLevel(LoggingLevel.INFO);
        as.setLoggingLevel(LoggingLevel.INFO);
        ga.optimise(as.getDataDef(), (FitnessFunction)as);
    }

    public static class GAJob
    extends AbstractJob
    implements JobWithOwner<GeneticAlgorithm> {
        protected GeneticAlgorithm m_ga = null;
        protected FitnessFunction m_ff = null;
        protected int[] m_weights = null;
        public double m_fitness = Double.NaN;

        public GAJob(GeneticAlgorithm ga, FitnessFunction ff, int[] weights) {
            this.m_ff = ff;
            this.m_weights = weights;
            this.m_ga = ga;
        }

        public GeneticAlgorithm getOwner() {
            return this.m_ga;
        }

        protected String postProcessCheck() {
            return null;
        }

        protected String preProcessCheck() {
            return null;
        }

        protected void process() throws Exception {
            this.m_fitness = this.m_ga.calcNewFitness(this.m_ff, this.m_weights);
        }

        public String toString() {
            return "GA Job";
        }
    }
}

