/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstainingClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.IntervalEstimator;
import weka.classifiers.ThreadSafeClassifier;
import weka.classifiers.meta.FilteredClassifier;
import weka.core.BatchPredictor;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class FilteredClassifierExt
extends FilteredClassifier
implements WeightedInstancesHandler,
IntervalEstimator,
AbstainingClassifier,
ThreadSafeClassifier {
    private static final long serialVersionUID = -696353491455375160L;
    protected Remove m_Remove = new Remove();
    protected boolean m_CanAbstain = false;

    public String globalInfo() {
        return super.globalInfo() + "\n\n" + "In addition to the default FilteredClassifier, one can specify a " + "range of attributes that are to be removed before applying the " + "actual filter. Useful to remove ID attributes, without having to " + "nest another FilteredClassifier.\n" + "\n" + "The meta-classifier also 'pretends' to be able to:\n" + "- handle weighted instances\n" + "- produce confidence intervals\n" + "This will only lead to reasonable results, of course, if the base " + "classifier supports this functionality.";
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe range of attributes to remove. 'first' and 'last' are \n\taccepted as well.\n\t(default: none)", "R", 1, "-R <att list>"));
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'R', (String[])options);
        if (tmpStr.length() != 0) {
            this.setRemoveAttributeIndices(tmpStr);
        } else {
            this.setRemoveAttributeIndices("");
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getRemoveAttributeIndices().length() > 0) {
            result.add("-R");
            result.add(this.getRemoveAttributeIndices());
        }
        result.addAll(Arrays.asList(super.getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public String removeAttributeIndicesTipText() {
        return "The attributes to remove before applying the actual filter.";
    }

    public void setRemoveAttributeIndices(String value) {
        this.m_Remove.setAttributeIndices(value);
    }

    public String getRemoveAttributeIndices() {
        return this.m_Remove.getAttributeIndices();
    }

    protected boolean isRemoveUsed() {
        return this.m_Remove.getAttributeIndices().length() > 0;
    }

    public Capabilities getCapabilities() {
        if (this.isRemoveUsed()) {
            return this.m_Remove.getCapabilities();
        }
        return super.getCapabilities();
    }

    protected Instances filter(Instances data) throws Exception {
        if (this.isRemoveUsed()) {
            this.m_Remove.setInputFormat(data);
            data = Filter.useFilter((Instances)data, (Filter)this.m_Remove);
        }
        return data;
    }

    public synchronized void buildClassifier(Instances data) throws Exception {
        super.buildClassifier(this.filter(data));
        this.m_CanAbstain = this.m_Classifier instanceof AbstainingClassifier && ((AbstainingClassifier)this.m_Classifier).canAbstain();
    }

    protected Instance filter(Filter filter, Instance instance) throws Exception {
        String filterName = filter.getClass().getName().replaceAll(".*\\.", "");
        if (filter.numPendingOutput() > 0) {
            throw new Exception(filterName + " filter output queue not empty!");
        }
        if (!filter.input(instance)) {
            throw new Exception(filterName + " filter didn't make the test instance immediately available!");
        }
        filter.batchFinished();
        instance = filter.output();
        return instance;
    }

    protected Instance filter(Instance instance) throws Exception {
        if (this.isRemoveUsed()) {
            instance = this.filter((Filter)this.m_Remove, instance);
        }
        return instance;
    }

    public synchronized double classifyInstance(Instance instance) throws Exception {
        return super.classifyInstance(instance);
    }

    public synchronized double[] distributionForInstance(Instance instance) throws Exception {
        return super.distributionForInstance(this.filter(instance));
    }

    public synchronized double[][] distributionsForInstances(Instances insts) throws Exception {
        if (this.getClassifier() instanceof BatchPredictor) {
            return super.distributionsForInstances(this.filter(insts));
        }
        double[][] result = new double[insts.numInstances()][insts.numClasses()];
        for (int i = 0; i < insts.numInstances(); ++i) {
            result[i] = this.distributionForInstance(insts.instance(i));
        }
        return result;
    }

    public synchronized double[][] predictIntervals(Instance instance, double confidenceLevel) throws Exception {
        if (this.m_Classifier instanceof IntervalEstimator) {
            return ((IntervalEstimator)this.m_Classifier).predictIntervals(this.filter(this.m_Filter, this.filter(instance)), confidenceLevel);
        }
        return new double[0][];
    }

    @Override
    public boolean canAbstain() {
        return this.m_CanAbstain;
    }

    @Override
    public synchronized double getAbstentionClassification(Instance inst) throws Exception {
        if (this.m_CanAbstain) {
            return ((AbstainingClassifier)this.m_Classifier).getAbstentionClassification(this.filter(this.m_Filter, this.filter(inst)));
        }
        return Utils.missingValue();
    }

    @Override
    public synchronized double[] getAbstentionDistribution(Instance inst) throws Exception {
        if (this.m_CanAbstain) {
            return ((AbstainingClassifier)this.m_Classifier).getAbstentionDistribution(this.filter(this.m_Filter, this.filter(inst)));
        }
        return null;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 11898 $");
    }

    public static void main(String[] args) {
        FilteredClassifierExt.runClassifier((Classifier)new FilteredClassifierExt(), (String[])args);
    }
}

