/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import adams.data.SortedList;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.neighboursearch.NearestNeighbourSearch;

public class NewNNSearch
extends NearestNeighbourSearch {
    private static final long serialVersionUID = 1915484723703917241L;
    protected double[] m_Distances;
    protected boolean m_SkipIdentical = false;
    protected SortedList<InstanceNode> m_neighbours = new SortedList();

    public NewNNSearch() {
    }

    public NewNNSearch(Instances insts) {
        super(insts);
        this.m_DistanceFunction.setInstances(insts);
    }

    public String globalInfo() {
        return "Class implementing the brute force search algorithm for nearest neighbour search.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.add(new Option("\tSkip identical instances (distances equal to zero).\n", "S", 1, "-S"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        this.setSkipIdentical(Utils.getFlag((char)'S', (String[])options));
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        if (this.getSkipIdentical()) {
            result.add("-S");
        }
        return result.toArray(new String[result.size()]);
    }

    public String skipIdenticalTipText() {
        return "Whether to skip identical instances (with distance 0 to the target)";
    }

    public void setSkipIdentical(boolean skip) {
        this.m_SkipIdentical = skip;
    }

    public boolean getSkipIdentical() {
        return this.m_SkipIdentical;
    }

    public Instance nearestNeighbour(Instance target) throws Exception {
        return this.kNearestNeighbours(target, 1).instance(0);
    }

    public Instances kNearestNeighbours(Instance target, int kNN) throws Exception {
        if (this.m_Stats != null) {
            this.m_Stats.searchStart();
        }
        this.m_neighbours.clear();
        double last_distance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.m_Instances.numInstances(); ++i) {
            double distance;
            if (target == this.m_Instances.instance(i)) continue;
            if (this.m_Stats != null) {
                this.m_Stats.incrPointCount();
            }
            if ((distance = this.m_DistanceFunction.distance(target, this.m_Instances.instance(i), last_distance, this.m_Stats)) == 0.0 && this.m_SkipIdentical || !(distance < last_distance)) continue;
            this.m_neighbours.add((Object)new InstanceNode(i, distance));
            if (this.m_neighbours.size() <= kNN) continue;
            this.m_neighbours.remove(this.m_neighbours.size() - 1);
            last_distance = ((InstanceNode)this.m_neighbours.get((int)(this.m_neighbours.size() - 1))).distance;
        }
        Instances neighbours = new Instances(this.m_Instances, this.m_neighbours.size());
        int index = 0;
        this.m_Distances = new double[this.m_neighbours.size()];
        for (InstanceNode in : this.m_neighbours) {
            this.m_Distances[index++] = in.distance;
            neighbours.add(this.m_Instances.instance(in.instance_index));
        }
        this.m_DistanceFunction.postProcessDistances(this.m_Distances);
        if (this.m_Stats != null) {
            this.m_Stats.searchFinish();
        }
        return neighbours;
    }

    public double[] getDistances() throws Exception {
        if (this.m_Distances == null) {
            throw new Exception("No distances available. Please call either kNearestNeighbours or nearestNeighbours first.");
        }
        return this.m_Distances;
    }

    public void setInstances(Instances insts) throws Exception {
        this.m_Instances = insts;
        this.m_DistanceFunction.setInstances(insts);
    }

    public void update(Instance ins) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No instances supplied yet. Cannot update withoutsupplying a set of instances first.");
        }
        this.m_DistanceFunction.update(ins);
    }

    public void addInstanceInfo(Instance ins) {
        if (this.m_Instances != null) {
            try {
                this.update(ins);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10824 $");
    }

    public class InstanceNode
    implements Comparable,
    Serializable {
        int instance_index;
        Double distance;

        public InstanceNode(int ins, Double dist) {
            this.instance_index = ins;
            this.distance = dist;
        }

        public int compareTo(Object o) {
            return Double.compare(this.distance, ((InstanceNode)o).distance);
        }
    }
}

