/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import java.io.StringWriter;
import java.io.Writer;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class ResultMatrixAdamsCSV
extends ResultMatrix {
    private static final long serialVersionUID = -171838863135042743L;

    public ResultMatrixAdamsCSV() {
        this(1, 1);
    }

    public ResultMatrixAdamsCSV(int cols, int rows) {
        super(cols, rows);
    }

    public ResultMatrixAdamsCSV(ResultMatrix matrix) {
        super(matrix);
    }

    public String globalInfo() {
        return "Generates the matrix in ADAMS CSV ('comma-separated values') format.";
    }

    public String getDisplayName() {
        return "CSV (ADAMS)";
    }

    public void clear() {
        super.clear();
        this.LEFT_PARENTHESES = "[";
        this.RIGHT_PARENTHESES = "]";
    }

    public int getDefaultRowNameWidth() {
        return 25;
    }

    public boolean getDefaultPrintColNames() {
        return false;
    }

    public boolean getDefaultEnumerateColNames() {
        return true;
    }

    protected String[][] toArray() {
        int inc;
        String[][] result = super.toArray();
        int col = 1;
        do {
            if (col == 1) {
                if (this.getShowStdDev()) {
                    result[0][col + 1] = result[0][col] + " SD";
                }
            } else if (this.getShowStdDev()) {
                result[0][col + 1] = result[0][col] + " SD";
                result[0][col + 2] = result[0][col] + " W/L";
            } else {
                result[0][col + 1] = result[0][col] + " W/L";
            }
            inc = col == 1 ? 1 : 2;
            if (!this.getShowStdDev()) continue;
            ++inc;
        } while ((col += inc) < result[0].length - 1);
        return result;
    }

    protected CsvSpreadSheetWriter getDefaultWriter() {
        CsvSpreadSheetWriter result = new CsvSpreadSheetWriter();
        result.setMissingValue("");
        String numFormat = "#.";
        for (int i = 0; i < Math.max(this.getMeanPrec(), this.getStdDevPrec()); ++i) {
            numFormat = numFormat + "#";
        }
        result.setNumberFormat(numFormat);
        return result;
    }

    protected String toString(SpreadSheet sheet) {
        StringWriter swriter = new StringWriter();
        CsvSpreadSheetWriter writer = this.getDefaultWriter();
        writer.write(sheet, (Writer)swriter);
        return "---" + sheet.getName() + "\n" + swriter.toString();
    }

    public String toStringHeader() {
        return "---Header\n" + new ResultMatrixPlainText((ResultMatrix)this).toStringHeader();
    }

    public String toStringMatrix() {
        SpreadSheet sheet = new SpreadSheet();
        sheet.setName("Matrix");
        String[][] cells = this.toArray();
        for (int i = 0; i < cells.length; ++i) {
            Object row = i == 0 ? sheet.getHeaderRow() : sheet.addRow();
            for (int n = 0; n < cells[i].length; ++n) {
                row.addCell("" + n).setContent(cells[i][n]);
            }
        }
        return this.toString(sheet);
    }

    public String toStringKey() {
        SpreadSheet sheet = new SpreadSheet();
        sheet.setName("Key");
        HeaderRow row = sheet.getHeaderRow();
        row.addCell("I").setContent("Index");
        row.addCell("S").setContent("Scheme");
        for (int i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            row = sheet.addRow();
            row.addCell("I").setContent(this.LEFT_PARENTHESES + (i + 1) + this.RIGHT_PARENTHESES);
            row.addCell("S").setContent(this.m_ColNames[i]);
        }
        return this.toString(sheet);
    }

    public String toStringSummary() {
        int i;
        SpreadSheet sheet = new SpreadSheet();
        sheet.setName("Summary");
        if (this.m_NonSigWins == null) {
            return this.toString(sheet);
        }
        HeaderRow row = sheet.getHeaderRow();
        for (i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            row.addCell("" + sheet.getColumnCount()).setContent(this.getSummaryTitle(i));
        }
        row.addCell("" + sheet.getColumnCount()).setContent("(No. of datasets where [col] >> [row])");
        for (i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            row = sheet.addRow();
            for (int j = 0; j < this.getColCount(); ++j) {
                if (this.getColHidden(j)) continue;
                if (j == i) {
                    row.addCell("" + j).setContentAsString("-");
                    continue;
                }
                row.addCell("" + j).setContentAsString(this.m_NonSigWins[i][j] + " (" + this.m_Wins[i][j] + ")");
            }
            row.addCell("" + (sheet.getColumnCount() - 1)).setContentAsString(this.getSummaryTitle(i) + " = " + this.removeFilterName(this.m_ColNames[i]));
        }
        return this.toString(sheet);
    }

    public String toStringRanking() {
        SpreadSheet sheet = new SpreadSheet();
        sheet.setName("Ranking");
        if (this.m_RankingWins == null) {
            return "---ranking\n" + this.toString(sheet);
        }
        HeaderRow row = sheet.getHeaderRow();
        row.addCell("D").setContentAsString(">-<");
        row.addCell("W").setContentAsString(">");
        row.addCell("L").setContentAsString("<");
        row.addCell("R").setContentAsString("Resultset");
        int[] ranking = Utils.sort((int[])this.m_RankingDiff);
        for (int i = this.getColCount() - 1; i >= 0; --i) {
            int curr = ranking[i];
            if (this.getColHidden(curr)) continue;
            row = sheet.addRow();
            row.addCell("D").setContent(Integer.valueOf(this.m_RankingDiff[curr]));
            row.addCell("W").setContent(Integer.valueOf(this.m_RankingWins[curr]));
            row.addCell("L").setContent(Integer.valueOf(this.m_RankingLosses[curr]));
            row.addCell("R").setContentAsString(this.m_ColNames[curr]);
        }
        return this.toString(sheet);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 11736 $");
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ResultMatrixAdamsCSV matrix = new ResultMatrixAdamsCSV(3, 3);
        matrix.addHeader("header1", "value1");
        matrix.addHeader("header2", "value2");
        matrix.addHeader("header2", "value3");
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            for (int n = 0; n < matrix.getColCount(); ++n) {
                matrix.setMean(n, i, (i + 1) * n);
                matrix.setStdDev(n, i, (double)(i + 1) * (double)n / 100.0);
                if (i != n) continue;
                if (i % 2 == 1) {
                    matrix.setSignificance(n, i, 1);
                    continue;
                }
                matrix.setSignificance(n, i, 2);
            }
        }
        System.out.println("\n\n--> " + matrix.getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(matrix.toStringHeader() + "\n");
        System.out.println(matrix.toStringMatrix() + "\n");
        System.out.println(matrix.toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        matrix.setShowStdDev(true);
        System.out.println(matrix.toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        matrix.setPrintColNames(false);
        System.out.println(matrix.toStringMatrix());
        System.out.println("\n4. second col missing\n");
        matrix.setColHidden(1, true);
        System.out.println(matrix.toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        matrix.setRowHidden(2, true);
        matrix.setPrintRowNames(false);
        System.out.println(matrix.toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        matrix.setMeanPrec(3);
        matrix.setPrintRowNames(false);
        System.out.println(matrix.toStringMatrix());
    }
}

