/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.data.statistics.StatUtils;
import adams.data.weka.WekaAttributeRange;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class InputSmearing
extends SimpleBatchFilter
implements Randomizable,
UnsupervisedFilter,
TechnicalInformationHandler {
    private static final long serialVersionUID = -4180301757935955561L;
    protected int m_Seed = 1;
    protected WekaAttributeRange m_AttributeRange = new WekaAttributeRange("first-last");
    protected double m_StdDev = 1.0;
    protected int[] m_Indices = new int[0];
    protected Double[] m_StdDevs = new Double[0];
    protected Random m_Random = new Random(this.m_Seed);

    public String globalInfo() {
        return "Performs input smearing on numeric attributes.\n\nFor more information, see:\n" + this.getTechnicalInformation();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INCOLLECTION);
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Knowledge Discovery and Data Mining");
        result.setValue(TechnicalInformation.Field.EDITOR, "Ng, Wee-Keong and Kitsuregawa, Masaru and Li, Jianzhong and Chang, Kuiyu");
        result.setValue(TechnicalInformation.Field.TITLE, "Improving on Bagging with Input Smearing");
        result.setValue(TechnicalInformation.Field.AUTHOR, "Frank, Eibe and Pfahringer, Bernhard");
        result.setValue(TechnicalInformation.Field.SERIES, "Lecture Notes in Computer Science");
        result.setValue(TechnicalInformation.Field.VOLUME, "3918");
        result.setValue(TechnicalInformation.Field.PAGES, "97-106");
        result.setValue(TechnicalInformation.Field.YEAR, "2006");
        result.setValue(TechnicalInformation.Field.ISBN, "978-3-540-33206-0");
        result.setValue(TechnicalInformation.Field.URL, "http://dx.doi.org/10.1007/11731139_14");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer Berlin Heidelberg");
        return result;
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tRandom number seed.\n\t(default 1)", "S", 1, "-S <num>"));
        result.addElement(new Option("\tThe multiplier for the standard deviation of a numeric attribute\n\tto use for performing the smearing (default 1.0)", "stddev", 1, "-stddev <number>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"R", (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setAttributeRange(new WekaAttributeRange(tmpStr));
        } else {
            this.setAttributeRange(new WekaAttributeRange("first-last"));
        }
        tmpStr = Utils.getOption((char)'S', (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setSeed(Integer.parseInt(tmpStr));
        } else {
            this.setSeed(1);
        }
        tmpStr = Utils.getOption((String)"stddev", (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setStdDev(Double.parseDouble(tmpStr));
        } else {
            this.setStdDev(1.0);
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-R");
        result.add(this.getAttributeRange().getRange());
        result.add("-S");
        result.add("" + this.getSeed());
        result.add("-stddev");
        result.add("" + this.getStdDev());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setSeed(int seed) {
        this.m_Seed = seed;
        this.reset();
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The random number seed to be used.";
    }

    public double getStdDev() {
        return this.m_StdDev;
    }

    public void setStdDev(double value) {
        this.m_StdDev = value;
        this.reset();
    }

    public String stdDevTipText() {
        return "The standard deviation to use for the input smearing.";
    }

    public void setAttributeRange(WekaAttributeRange value) {
        this.m_AttributeRange = value;
        this.reset();
    }

    public WekaAttributeRange getAttributeRange() {
        return this.m_AttributeRange;
    }

    public String attributeRangeTipText() {
        return "The range of attributes to work on; " + this.m_AttributeRange.getExample();
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.disable(Capabilities.Capability.RELATIONAL_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_AttributeRange.setData(inputFormat);
        return new Instances(inputFormat, 0);
    }

    protected Instances process(Instances instances) throws Exception {
        int i;
        if (!this.isFirstBatchDone()) {
            this.m_Random = new Random(this.m_Seed);
            this.m_Indices = this.m_AttributeRange.getIntIndices();
            this.m_StdDevs = new Double[this.m_Indices.length];
            for (i = 0; i < this.m_Indices.length; ++i) {
                double[] values = instances.attributeToDoubleArray(this.m_Indices[i]);
                this.m_StdDevs[i] = StatUtils.stddev((double[])values, (boolean)true);
            }
        }
        Instances result = this.getOutputFormat();
        for (Instance inst : instances) {
            Instance newInst = (Instance)inst.copy();
            for (i = 0; i < this.m_Indices.length; ++i) {
                newInst.setValue(this.m_Indices[i], newInst.value(this.m_Indices[i]) + this.m_Random.nextGaussian() * this.m_StdDevs[i] * this.m_StdDev);
            }
            result.add(newInst);
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 11536 $");
    }

    public static void main(String[] args) {
        InputSmearing.runFilter((Filter)new InputSmearing(), (String[])args);
    }
}

