/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.BinarySparseInstance;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;
import weka.filters.UnsupervisedFilter;

public class LogTransform
extends SimpleStreamFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = -8798054963031276516L;
    protected Range m_AttributeRange = new Range("first-last");
    protected boolean m_AddOne = false;

    public String globalInfo() {
        return "Transforms all numeric attributes in the specified range using a log-transform.\nThe class attribute is omitted.\nIf a value less or equal to zero is encountered, a missing value is output.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\tThe range of attributes to process.\n\t(default: first-last)", "R", 1, "-R <range specification>"));
        result.add(new Option("\tWhether to add '1' to the values before transform.\n\tUseful when dealing with counts, avoiding 0 counts.\n\t(default: off)", "add-one", 0, "-add-one"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.reset();
        String tmpStr = Utils.getOption((String)"R", (String[])options);
        if (tmpStr.length() != 0) {
            this.setAttributeRange(tmpStr);
        } else {
            this.setAttributeRange("first-last");
        }
        this.setAddOne(Utils.getFlag((String)"add-one", (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>(Arrays.asList(super.getOptions()));
        result.add("-R");
        result.add("" + this.getAttributeRange());
        if (this.getAddOne()) {
            result.add("-add-one");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setAttributeRange(String value) {
        this.m_AttributeRange.setRanges(value);
    }

    public String getAttributeRange() {
        return this.m_AttributeRange.getRanges();
    }

    public String attributeRangeTipText() {
        return "The range of attributes to process.";
    }

    public void setAddOne(boolean value) {
        this.m_AddOne = value;
    }

    public boolean getAddOne() {
        return this.m_AddOne;
    }

    public String addOneTipText() {
        return "Whether to add '1' to the values before performing log-transform.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_AttributeRange.setUpper(inputFormat.numAttributes() - 1);
        return new Instances(inputFormat, 0);
    }

    protected Instance process(Instance instance) throws Exception {
        double[] values = (double[])instance.toDoubleArray().clone();
        for (int i = 0; i < values.length; ++i) {
            if (instance.isMissing(i) || i == instance.classIndex() || !instance.attribute(i).isNumeric() || !this.m_AttributeRange.isInRange(i)) continue;
            if (this.m_AddOne) {
                int n = i;
                values[n] = values[n] + 1.0;
            }
            values[i] = values[i] > 0.0 ? Math.log(values[i]) : Utils.missingValue();
        }
        Object result = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), values) : (instance instanceof BinarySparseInstance ? new BinarySparseInstance(instance.weight(), values) : new DenseInstance(instance.weight(), values));
        result.setDataset(this.getOutputFormat());
        this.copyValues((Instance)result, false, instance.dataset(), this.getOutputFormat());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 4521 $");
    }

    public static void main(String[] args) {
        LogTransform.runFilter((Filter)new LogTransform(), (String[])args);
    }
}

