/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import adams.core.base.BaseString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.SingleIndex;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.WekaException;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class MergeManyAttributes
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = -8596728919861340618L;
    public static final int VALUESDIFFER_MISSING = 0;
    public static final int VALUESDIFFER_AVERAGE = 1;
    public static final Tag[] TAGS_VALUESDIFFER = new Tag[]{new Tag(0, "MISSING", "Set to missing"), new Tag(1, "AVERAGE", "Take average (numeric only)")};
    public static final int ONEMISSING_MISSING = 0;
    public static final int ONEMISSING_USE_FIRST_PRESENT = 1;
    public static final Tag[] TAGS_ONEMISSING = new Tag[]{new Tag(0, "MISSING", "Set to missing"), new Tag(1, "FIRST", "Use first present value")};
    public static final String DEFAULT_REMOVE_CHARS = " -_.";
    protected BaseString[] m_AttributeNames = new BaseString[]{new BaseString("att1"), new BaseString("att2")};
    protected int m_Differ = 0;
    protected int m_OneMissing = 0;
    protected String m_RemoveChars = " -_.";
    protected SingleIndex m_MergedIndex = new SingleIndex("");
    protected String m_Merged;

    public String globalInfo() {
        return "Merges two or more attributes, offers various strategies if values differ or not present.\nUses the common subsequence (either from start or end) of the attributes as name of the merged attribute, otherwise the concatenation of them (separated by '-'). If this new name should already be present, then a number is appended to the name to make it unique.\nThe merged attribute can either be left at the default position (whichever one of the attributes that comes first) or moved to a specific one.\nIf one of the attributes to be merged is the current class attribute, the newly created merged attribute will become the new class attribute.";
    }

    public Enumeration listOptions() {
        SelectedTag tag;
        int i;
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tThe name of the attribute, can be supplied multiple times.", "att-name", 1, "-att-name <att name>"));
        result.addElement(new Option("\tThe characters to remove from the start/end of the\n\tgenerated name for the merged attribute.\n\t(default:  -_.)", "remove-chars", 1, "-remove-chars <chars>"));
        result.addElement(new Option("\tThe new position for the merged attribute.\n\tEmpty string is default position, i.e., either the position\n\tof the first or second attribute (whichever comes first)\n\t(default: )", "merged-index", 1, "-merged-index <position>"));
        String param = "";
        for (i = 0; i < TAGS_VALUESDIFFER.length; ++i) {
            if (i > 0) {
                param = param + "|";
            }
            tag = new SelectedTag(TAGS_VALUESDIFFER[i].getID(), TAGS_VALUESDIFFER);
            param = param + tag.getSelectedTag().getIDStr();
        }
        result.addElement(new Option("\tThe strategy to apply in case the values of the attributes differ.\n\t(default: " + new SelectedTag(0, TAGS_VALUESDIFFER) + ")", "differ", 1, "-differ <" + param + ">"));
        param = "";
        for (i = 0; i < TAGS_ONEMISSING.length; ++i) {
            if (i > 0) {
                param = param + "|";
            }
            tag = new SelectedTag(TAGS_ONEMISSING[i].getID(), TAGS_ONEMISSING);
            param = param + tag.getSelectedTag().getIDStr();
        }
        result.addElement(new Option("\tThe strategy to apply in case one of the values is missing.\n\t(default: " + new SelectedTag(0, TAGS_ONEMISSING) + ")", "one-missing", 1, "-one-missing <" + param + ">"));
        return result.elements();
    }

    public String[] getOptions() {
        int i;
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        for (i = 0; i < this.m_AttributeNames.length; ++i) {
            result.add("-att-name");
            result.add("" + this.m_AttributeNames[i].stringValue());
        }
        if (this.getMergedIndex().length() > 0) {
            result.add("-merged-index");
            result.add("" + this.getMergedIndex());
        }
        result.add("-remove-chars");
        result.add("" + this.getRemoveChars());
        result.add("-differ");
        result.add("" + this.getDiffer().getSelectedTag().getIDStr());
        result.add("-one-missing");
        result.add("" + this.getOneMissing().getSelectedTag().getIDStr());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr;
        super.setOptions(options);
        ArrayList<BaseString> list = new ArrayList<BaseString>();
        do {
            if ((tmpStr = Utils.getOption((String)"att-name", (String[])options)).length() <= 0) continue;
            list.add(new BaseString(tmpStr));
        } while (tmpStr.length() > 0);
        while (list.size() < 2) {
            list.add(new BaseString("att" + (list.size() + 1)));
        }
        this.setAttributeNames(list.toArray(new BaseString[list.size()]));
        tmpStr = Utils.getOption((String)"merged-index", (String[])options);
        this.setMergedIndex(tmpStr);
        tmpStr = Utils.getOption((String)"remove-chars", (String[])options);
        if (tmpStr.length() != 0) {
            this.setRemoveChars(tmpStr);
        } else {
            this.setRemoveChars(DEFAULT_REMOVE_CHARS);
        }
        tmpStr = Utils.getOption((String)"differ", (String[])options);
        if (tmpStr.length() != 0) {
            this.setDiffer(new SelectedTag(tmpStr, TAGS_VALUESDIFFER));
        } else {
            this.setDiffer(new SelectedTag(0, TAGS_VALUESDIFFER));
        }
        tmpStr = Utils.getOption((String)"one-missing", (String[])options);
        if (tmpStr.length() != 0) {
            this.setOneMissing(new SelectedTag(tmpStr, TAGS_ONEMISSING));
        } else {
            this.setOneMissing(new SelectedTag(0, TAGS_ONEMISSING));
        }
    }

    public void setAttributeNames(BaseString[] value) {
        this.m_AttributeNames = value;
    }

    public BaseString[] getAttributeNames() {
        return this.m_AttributeNames;
    }

    public String attributeNamesTipText() {
        return "The names of the attributes to merge.";
    }

    public void setMergedIndex(String value) {
        this.m_MergedIndex.setSingleIndex(value);
    }

    public String getMergedIndex() {
        return this.m_MergedIndex.getSingleIndex();
    }

    public String mergedIndexTipText() {
        return "The new index of the merged attribute, leave empty for default position; 'first' and 'last' are accepted as well.";
    }

    public void setRemoveChars(String value) {
        this.m_RemoveChars = value;
    }

    public String getRemoveChars() {
        return this.m_RemoveChars;
    }

    public String removeCharsTipText() {
        return "The characters to remove from the start/end of the generated name for the merged attribute.";
    }

    public void setDiffer(SelectedTag value) {
        if (value.getTags() == TAGS_VALUESDIFFER) {
            this.m_Differ = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getDiffer() {
        return new SelectedTag(this.m_Differ, TAGS_VALUESDIFFER);
    }

    public String differTipText() {
        return "The strategy to apply if the values differ.";
    }

    public void setOneMissing(SelectedTag value) {
        if (value.getTags() == TAGS_ONEMISSING) {
            this.m_OneMissing = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getOneMissing() {
        return new SelectedTag(this.m_OneMissing, TAGS_ONEMISSING);
    }

    public String oneMissingTipText() {
        return "Sets the strategy to apply if one of the values is missing.";
    }

    protected String commonSubsequence(String s1, String s2, boolean forward) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < Math.min(s1.length(), s2.length()); ++i) {
            if (forward) {
                if (s1.charAt(i) != s2.charAt(i)) break;
                result.append(s1.charAt(i));
                continue;
            }
            if (s1.charAt(s1.length() - i - 1) != s2.charAt(s2.length() - i - 1)) break;
            result.insert(0, s1.charAt(s1.length() - i - 1));
        }
        if (this.m_RemoveChars.length() > 0) {
            while (result.length() > 0 && this.m_RemoveChars.indexOf(result.charAt(0)) > -1) {
                result.delete(0, 1);
            }
            while (result.length() > 0 && this.m_RemoveChars.indexOf(result.charAt(result.length() - 1)) > -1) {
                result.delete(result.length() - 1, result.length());
            }
        }
        return result.toString();
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        Attribute oldAtt;
        String common;
        int i;
        if (this.m_AttributeNames.length < 2) {
            throw new IllegalStateException("At least two attribute names must be defined!");
        }
        HashSet<String> attNames = new HashSet<String>();
        for (i = 0; i < this.m_AttributeNames.length; ++i) {
            if (inputFormat.attribute(this.m_AttributeNames[i].stringValue()) == null) {
                throw new WekaException("Attribute #" + (i + 1) + " '" + this.m_AttributeNames[i] + "' not found!");
            }
            attNames.add(this.m_AttributeNames[i].stringValue());
        }
        this.m_Merged = this.m_AttributeNames[0].stringValue();
        for (i = 1; i < this.m_AttributeNames.length; ++i) {
            common = this.commonSubsequence(this.m_Merged, this.m_AttributeNames[i].stringValue(), true);
            if (common.length() == 0) {
                common = this.commonSubsequence(this.m_Merged, this.m_AttributeNames[i].stringValue(), false);
            }
            if (common.length() == 0) {
                common = this.m_Merged + "-" + this.m_AttributeNames[i].stringValue();
            }
            this.m_Merged = common;
        }
        i = 1;
        common = this.m_Merged;
        while (inputFormat.attribute(this.m_Merged) != null) {
            this.m_Merged = common + "-" + ++i;
        }
        HashSet<String> labels = new HashSet<String>();
        block11: for (i = 0; i < inputFormat.numAttributes(); ++i) {
            oldAtt = inputFormat.attribute(i);
            if (!attNames.contains(oldAtt.name())) continue;
            switch (oldAtt.type()) {
                case 1: {
                    Enumeration enm = oldAtt.enumerateValues();
                    while (enm.hasMoreElements()) {
                        labels.add(enm.nextElement().toString());
                    }
                    continue block11;
                }
            }
        }
        ArrayList values = new ArrayList(labels);
        Collections.sort(values);
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        boolean done = false;
        int current = -1;
        Attribute newAtt = null;
        for (i = 0; i < inputFormat.numAttributes(); ++i) {
            oldAtt = inputFormat.attribute(i);
            if (attNames.contains(oldAtt.name())) {
                if (done) continue;
                switch (oldAtt.type()) {
                    case 0: {
                        newAtt = new Attribute(this.m_Merged);
                        break;
                    }
                    case 1: {
                        newAtt = new Attribute(this.m_Merged, values);
                        break;
                    }
                    case 2: {
                        newAtt = new Attribute(this.m_Merged, (List)null);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Cannot merged attributes of type " + Attribute.typeToString((Attribute)oldAtt));
                    }
                }
                done = true;
                current = atts.size();
                atts.add(newAtt);
                continue;
            }
            newAtt = (Attribute)oldAtt.copy();
            atts.add(newAtt);
        }
        if (this.m_MergedIndex.getSingleIndex().length() > 0 && current > -1) {
            this.m_MergedIndex.setUpper(atts.size() - 1);
            newAtt = (Attribute)atts.remove(current);
            atts.add(this.m_MergedIndex.getIndex(), newAtt);
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        if (inputFormat.classIndex() > -1) {
            if (result.attribute(inputFormat.classAttribute().name()) != null) {
                result.setClass(result.attribute(inputFormat.classAttribute().name()));
            } else {
                result.setClass(result.attribute(this.m_Merged));
            }
        }
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    protected Instances process(Instances instances) throws Exception {
        int i;
        Instances result = this.getOutputFormat();
        HashSet<Integer> indicesOld = new HashSet<Integer>();
        for (i = 0; i < this.m_AttributeNames.length; ++i) {
            indicesOld.add(instances.attribute(this.m_AttributeNames[i].stringValue()).index());
        }
        int indexMerged = result.attribute(this.m_Merged).index();
        boolean isNumeric = result.attribute(indexMerged).isNumeric();
        boolean isString = result.attribute(indexMerged).isString();
        for (i = 0; i < instances.numInstances(); ++i) {
            double[] valuesNew;
            double[] valuesOld;
            Instance instOld;
            block25: {
                int firstIndex;
                block27: {
                    block26: {
                        instOld = instances.instance(i);
                        valuesOld = instOld.toDoubleArray();
                        valuesNew = new double[result.numAttributes()];
                        boolean oneMissing = false;
                        boolean allMissing = true;
                        for (Integer index : indicesOld) {
                            if (Utils.isMissingValue((double)valuesOld[index])) {
                                oneMissing = true;
                                continue;
                            }
                            allMissing = false;
                        }
                        if (!oneMissing) break block26;
                        switch (this.m_OneMissing) {
                            case 0: {
                                valuesNew[indexMerged] = Utils.missingValue();
                                break block25;
                            }
                            case 1: {
                                if (allMissing) {
                                    valuesNew[indexMerged] = Utils.missingValue();
                                } else {
                                    for (int n = 0; n < instances.numAttributes(); ++n) {
                                        if (!indicesOld.contains(n) || Utils.isMissingValue((double)valuesOld[n])) continue;
                                        valuesNew[indexMerged] = isNumeric ? valuesOld[n] : (isString ? (double)result.attribute(indexMerged).addStringValue(instOld.stringValue(n)) : (double)result.attribute(indexMerged).indexOfValue(instOld.stringValue(n)));
                                        break block25;
                                    }
                                }
                                break block25;
                            }
                            default: {
                                throw new IllegalStateException("Unhandled type (oneMissing): " + this.m_OneMissing);
                            }
                        }
                    }
                    boolean different = false;
                    firstIndex = -1;
                    for (Integer index : indicesOld) {
                        if (firstIndex == -1) {
                            firstIndex = index;
                            continue;
                        }
                        if ((!isNumeric || valuesOld[firstIndex] == valuesOld[index]) && (isNumeric || instOld.stringValue(firstIndex).equals(instOld.stringValue(index.intValue())))) continue;
                        different = true;
                        break;
                    }
                    if (!different) break block27;
                    switch (this.m_Differ) {
                        case 0: {
                            valuesNew[indexMerged] = Utils.missingValue();
                            break block25;
                        }
                        case 1: {
                            if (isNumeric) {
                                valuesNew[indexMerged] = 0.0;
                                for (Integer index : indicesOld) {
                                    int n = indexMerged;
                                    valuesNew[n] = valuesNew[n] + valuesOld[index];
                                }
                                if (indicesOld.size() > 0) {
                                    int n = indexMerged;
                                    valuesNew[n] = valuesNew[n] / (double)indicesOld.size();
                                } else {
                                    valuesNew[indexMerged] = Utils.missingValue();
                                }
                            } else {
                                valuesNew[indexMerged] = Utils.missingValue();
                            }
                            break block25;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled type (differ): " + this.m_Differ);
                        }
                    }
                }
                valuesNew[indexMerged] = isNumeric ? valuesOld[firstIndex] : (isString ? (double)result.attribute(indexMerged).addStringValue(instOld.stringValue(firstIndex)) : (double)result.attribute(indexMerged).indexOfValue(instOld.stringValue(firstIndex)));
            }
            int indexOld = 0;
            int indexNew = 0;
            while (indexOld < instOld.numAttributes()) {
                if (indicesOld.contains(indexOld)) {
                    ++indexOld;
                    continue;
                }
                if (indexNew == indexMerged) {
                    ++indexNew;
                    continue;
                }
                valuesNew[indexNew] = Utils.isMissingValue((double)valuesOld[indexOld]) ? valuesOld[indexOld] : (result.attribute(indexNew).isString() ? (double)result.attribute(indexNew).addStringValue(instOld.stringValue(indexOld)) : valuesOld[indexOld]);
                ++indexNew;
                ++indexOld;
            }
            DenseInstance instNew = new DenseInstance(instOld.weight(), valuesNew);
            result.add((Instance)instNew);
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10824 $");
    }

    public static void main(String[] args) {
        MergeManyAttributes.runFilter((Filter)new MergeManyAttributes(), (String[])args);
    }
}

