/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import adams.data.weka.WekaAttributeIndex;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.AArffLoader;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class RemoveTestInstances
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = -6784901276150528252L;
    protected File m_TestSet = new File(".");
    protected boolean m_UseCustomLoader = false;
    protected AbstractFileLoader m_CustomLoader = new AArffLoader();
    protected WekaAttributeIndex m_ID = new WekaAttributeIndex("first");
    protected boolean m_Invert = false;

    public String globalInfo() {
        return "Removes all instances of the provided test set from the data passing through.\nRequires an attribute in the data that uniquely identifies instances across datasets.";
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe test set to load.\n", "test-set", 1, "-test-set <file>"));
        result.addElement(new Option("\tWhether to use a custom loader.\n", "use-custom-loader", 0, "-use-custom-loader"));
        result.addElement(new Option("\tThe custom loader to use.\n", "custom-loader", 1, "-custom-loader <classname + options>"));
        result.addElement(new Option("\tThe index/name of ID attribute to use for identifying rows.\n", "id", 1, "-id <1-based index or name>"));
        result.addElement(new Option("\tWhether to invert the matching (ie keep rather than remove).\n", "invert", 0, "-invert"));
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"test-set", (String[])options);
        if (tmpStr.isEmpty()) {
            this.setTestSet(new File("."));
        } else {
            this.setTestSet(new File(tmpStr));
        }
        this.setUseCustomLoader(Utils.getFlag((String)"use-custom-loader", (String[])options));
        tmpStr = Utils.getOption((String)"custom-loader", (String[])options);
        if (tmpStr.isEmpty()) {
            this.setCustomLoader((AbstractFileLoader)new AArffLoader());
        } else {
            String[] tmpOptions = Utils.splitOptions((String)tmpStr);
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setCustomLoader((AbstractFileLoader)Utils.forName(AbstractFileLoader.class, (String)tmpStr, (String[])tmpOptions));
        }
        tmpStr = Utils.getOption((String)"id", (String[])options);
        if (tmpStr.isEmpty()) {
            this.setID(new WekaAttributeIndex("first"));
        } else {
            this.setID(new WekaAttributeIndex(tmpStr));
        }
        this.setInvert(Utils.getFlag((String)"invert", (String[])options));
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-test-set");
        result.add("" + this.getTestSet());
        if (this.getUseCustomLoader()) {
            result.add("-use-custom-loader");
            result.add("-custom-loader");
            result.add(Utils.toCommandLine((Object)this.getCustomLoader()));
        }
        result.add("-id");
        result.add(this.getID().getIndex());
        if (this.getInvert()) {
            result.add("-invert");
        }
        result.addAll(Arrays.asList(super.getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public void setTestSet(File value) {
        this.m_TestSet = value;
    }

    public File getTestSet() {
        return this.m_TestSet;
    }

    public String testSetTipText() {
        return "The file containing the test set to remove from the data passing through the filter.";
    }

    public void setUseCustomLoader(boolean value) {
        this.m_UseCustomLoader = value;
    }

    public boolean getUseCustomLoader() {
        return this.m_UseCustomLoader;
    }

    public String useCustomLoaderTipText() {
        return "If enabled, the specified custom loader is used for loading the test set rather than using automatic loading.";
    }

    public void setCustomLoader(AbstractFileLoader value) {
        this.m_CustomLoader = value;
    }

    public AbstractFileLoader getCustomLoader() {
        return this.m_CustomLoader;
    }

    public String customLoaderTipText() {
        return "The custom loader to use (if enabled).";
    }

    public void setID(WekaAttributeIndex value) {
        this.m_ID = value;
    }

    public WekaAttributeIndex getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The attribute name or index to use for identifying rows; " + this.m_ID.getExample();
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If enabled, the matching sense gets inverted and the instances with the matching ID are kept rather than removed.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.disable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.disable(Capabilities.Capability.RELATIONAL_CLASS);
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_ID.setData(inputFormat);
        if (this.m_ID.getIntIndex() == -1) {
            throw new IllegalStateException("Attribute name/index not found: " + (Object)((Object)this.m_ID));
        }
        if (!this.m_TestSet.exists()) {
            throw new IllegalStateException("Test set does not exist: " + this.m_TestSet);
        }
        if (this.m_TestSet.isDirectory()) {
            throw new IllegalStateException("Test set points to a directory: " + this.m_TestSet);
        }
        return new Instances(inputFormat, 0);
    }

    protected Instances loadTestSet() throws Exception {
        Instances result;
        if (this.getUseCustomLoader()) {
            this.m_CustomLoader.setFile(this.getTestSet());
            result = this.m_CustomLoader.getDataSet();
        } else {
            result = ConverterUtils.DataSource.read((String)this.getTestSet().getAbsolutePath());
        }
        if (result == null) {
            throw new IllegalStateException("Failed to load test set: " + this.getTestSet());
        }
        return result;
    }

    protected Instances process(Instances instances) throws Exception {
        if (this.m_FirstBatchDone) {
            return new Instances(instances);
        }
        Instances test = this.loadTestSet();
        this.m_ID.setData(test);
        int index = this.m_ID.getIntIndex();
        if (index == -1) {
            throw new IllegalStateException("ID attribute not found in test set: " + this.m_ID.getIndex() + "\n" + new Instances(test, 0));
        }
        boolean numeric = test.attribute(index).isNumeric();
        HashSet<String> ids = new HashSet<String>();
        for (Instance inst : test) {
            if (numeric) {
                ids.add("" + inst.value(index));
                continue;
            }
            ids.add(inst.stringValue(index));
        }
        Instances result = new Instances(instances, instances.numInstances());
        this.m_ID.setData(instances);
        index = this.m_ID.getIntIndex();
        if (index == -1) {
            throw new IllegalStateException("ID attribute not found in dataset: " + this.m_ID.getIndex() + "\n" + new Instances(instances, 0));
        }
        for (Instance inst : instances) {
            boolean exists = numeric ? ids.contains("" + inst.value(index)) : ids.contains(inst.stringValue(index));
            if (exists && !this.m_Invert || !exists && this.m_Invert) continue;
            result.add((Instance)inst.copy());
        }
        result.compactify();
        if (this.m_Debug) {
            System.out.println("Reduction: " + instances.numInstances() + " -> " + result.numInstances());
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 11680 $");
    }

    public static void main(String[] args) {
        RemoveTestInstances.runFilter((Filter)new RemoveTestInstances(), (String[])args);
    }
}

