/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize.plugins;

import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.Properties;
import adams.core.Range;
import adams.data.container.DataPoint;
import adams.data.sequence.XYSequencePointComparator;
import adams.flow.sink.sequenceplotter.MouseClickAction;
import adams.flow.sink.sequenceplotter.SequencePlotContainer;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.flow.sink.sequenceplotter.SequencePlotSequence;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.flow.sink.sequenceplotter.ViewDataClickAction;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.CrossHitDetector;
import adams.gui.visualization.sequence.CrossPaintlet;
import adams.gui.visualization.sequence.LinearRegressionOverlayPaintlet;
import adams.gui.visualization.sequence.MultiPaintlet;
import adams.gui.visualization.sequence.StraightLineOverlayPaintlet;
import adams.gui.visualization.sequence.TextOverlayPaintlet;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JMenuItem;
import weka.core.Instance;
import weka.core.Instances;
import weka.gui.visualize.plugins.ErrorVisualizePlugin;

public class FixedClassifierErrorsPlot
implements ErrorVisualizePlugin {
    public JMenuItem getVisualizeMenuItem(final Instances predInst) {
        JMenuItem result = new JMenuItem("Classifier errors plot (fixed)");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesParameterPanel params = new PropertiesParameterPanel();
                params.addPropertyType("Meta-data", PropertiesParameterPanel.PropertyType.RANGE);
                params.setHelp("Meta-data", "The range of attribiutes to add as meta-data; " + new Range().getExample());
                params.addPropertyType("Trend", PropertiesParameterPanel.PropertyType.BOOLEAN);
                params.setHelp("Trend", "Adds a best fit line using linear regression");
                Properties props = new Properties();
                props.setProperty("Meta-data", "first-last");
                props.setBoolean("Trend", Boolean.valueOf(true));
                params.setPropertyOrder(new String[]{"Meta-data", "Trend"});
                params.setProperties(props);
                ApprovalDialog dialog = new ApprovalDialog(null, Dialog.ModalityType.DOCUMENT_MODAL);
                dialog.setTitle("Plot setup");
                dialog.getContentPane().add((Component)params, "Center");
                dialog.pack();
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
                if (dialog.getOption() != 0) {
                    return;
                }
                props = params.getProperties();
                Range range = new Range(props.getProperty("Meta-data"));
                range.setMax(predInst.numAttributes());
                boolean trend = props.getBoolean("Trend");
                SequencePlotterPanel plot = new SequencePlotterPanel(predInst.relationName());
                CrossPaintlet paintlet = new CrossPaintlet();
                plot.setPaintlet((XYSequencePaintlet)paintlet);
                MultiPaintlet overlays = new MultiPaintlet();
                StraightLineOverlayPaintlet overlay = new StraightLineOverlayPaintlet();
                overlay.setColor(Color.RED.darker());
                LinearRegressionOverlayPaintlet lrPaintlet = new LinearRegressionOverlayPaintlet();
                lrPaintlet.setOutputSlopeIntercept(true);
                TextOverlayPaintlet text = new TextOverlayPaintlet();
                if (trend) {
                    text.setText("Red = diagonal, Black = LR fit");
                    text.setY(30);
                } else {
                    text.setText("Red = diagonal");
                }
                if (trend) {
                    overlays.setSubPaintlets(new XYSequencePaintlet[]{overlay, lrPaintlet, text});
                } else {
                    overlays.setSubPaintlets(new XYSequencePaintlet[]{overlay, text});
                }
                plot.setOverlayPaintlet((XYSequencePaintlet)overlays);
                FancyTickGenerator tick = new FancyTickGenerator();
                tick.setNumTicks(10);
                ViewDataClickAction action = new ViewDataClickAction();
                action.setHitDetector((AbstractXYSequencePointHitDetector)new CrossHitDetector());
                plot.setMouseClickAction((MouseClickAction)action);
                plot.getPlot().getAxis(Axis.LEFT).setTickGenerator(tick.shallowCopy());
                plot.getPlot().getAxis(Axis.LEFT).setNumberFormat("0.0");
                plot.getPlot().getAxis(Axis.LEFT).setNthValueToShow(2);
                plot.getPlot().getAxis(Axis.LEFT).setAxisName("Predicted");
                plot.getPlot().getAxis(Axis.BOTTOM).setTickGenerator(tick.shallowCopy());
                plot.getPlot().getAxis(Axis.BOTTOM).setNumberFormat("0.0");
                plot.getPlot().getAxis(Axis.BOTTOM).setNthValueToShow(2);
                plot.getPlot().getAxis(Axis.BOTTOM).setAxisName("Actual");
                SequencePlotSequence seq = new SequencePlotSequence();
                seq.setComparison(XYSequencePointComparator.Comparison.X_AND_Y);
                seq.setID("Act vs Pred");
                DateFormat format = DateUtils.getTimestampFormatter();
                for (int i = 0; i < predInst.numInstances(); ++i) {
                    Instance inst = predInst.instance(i);
                    double actual = inst.value(predInst.classIndex());
                    double predicted = inst.value(predInst.classIndex() - 1);
                    SequencePlotPoint point = new SequencePlotPoint("Act vs Pred", actual, predicted);
                    HashMap<String, Object> meta = new HashMap<String, Object>();
                    meta.put("Error", actual - predicted);
                    if (predInst.numAttributes() > 2) {
                        for (int n = 0; n < predInst.numAttributes(); ++n) {
                            if (n == predInst.classIndex() || n == predInst.classIndex() - 1 || !range.isInRange(n)) continue;
                            String name = "Att-" + predInst.attribute(n).name();
                            int type = predInst.attribute(n).type();
                            if (inst.isMissing(n)) {
                                meta.put(name, "?");
                                continue;
                            }
                            if (type == 0) {
                                meta.put(name, inst.value(n));
                                continue;
                            }
                            if (type == 3) {
                                meta.put(name, format.format(new Date((int)inst.value(n))));
                                continue;
                            }
                            if (type == 1) {
                                meta.put(name, inst.stringValue(n));
                                continue;
                            }
                            if (type != 2) continue;
                            meta.put(name, inst.stringValue(n));
                        }
                    }
                    point.setMetaData(meta);
                    seq.add((DataPoint)point);
                }
                SequencePlotContainer cont = (SequencePlotContainer)((XYSequenceContainerManager)plot.getContainerManager()).newContainer((Comparable)seq);
                ((XYSequenceContainerManager)plot.getContainerManager()).add((XYSequenceContainer)cont);
                dialog = new ApprovalDialog(null, Dialog.ModalityType.MODELESS);
                dialog.setDefaultCloseOperation(2);
                dialog.setTitle("Absolute classifier errors");
                dialog.getContentPane().add((Component)plot, "Center");
                dialog.setSize(800, 600);
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            }
        });
        return result;
    }

    public String getMinVersion() {
        return "3.5.9";
    }

    public String getMaxVersion() {
        return "3.8.0";
    }

    public String getDesignVersion() {
        return "3.7.0";
    }
}

