/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.WekaModelReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class WekaModelReaderTest
extends AbstractFlowTest {
    public WekaModelReaderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("reptree.model");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("reptree.model");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(WekaModelReaderTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp1 = new AbstractActor[3];
            SingleFileSupplier tmp2 = new SingleFileSupplier();
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("file");
            tmp2.setFile((PlaceholderFile)argOption.valueOf("${TMP}/reptree.model"));
            tmp1[0] = tmp2;
            WekaModelReader tmp4 = new WekaModelReader();
            tmp1[1] = tmp4;
            DumpFile tmp5 = new DumpFile();
            argOption = (AbstractArgumentOption)tmp5.getOptionManager().findByProperty("outputFile");
            tmp5.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            tmp1[2] = tmp5;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            WekaModelReaderTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaModelReaderTest.runTest((Test)WekaModelReaderTest.suite());
    }
}

