/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.container.WekaModelContainer;
import adams.flow.sink.AbstractFileWriter;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Vector;

public abstract class AbstractWekaModelWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = -259222073894194923L;

    public String outputFileTipText() {
        return "The filename to save the model (and optional header) in.";
    }

    public Class[] accepts() {
        Vector<Class> result = new Vector<Class>();
        result.add(WekaModelContainer.class);
        result.addAll(Arrays.asList(this.getAdditionalAcceptedClasses()));
        return result.toArray(new Class[result.size()]);
    }

    protected Class[] getAdditionalAcceptedClasses() {
        return new Class[0];
    }

    protected String doExecute() {
        String result = null;
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.m_OutputFile.getAbsolutePath()));
            if (this.m_InputToken.getPayload() instanceof WekaModelContainer) {
                WekaModelContainer cont = (WekaModelContainer)((Object)this.m_InputToken.getPayload());
                oos.writeObject(cont.getValue("Model"));
                if (cont.hasValue("Header")) {
                    oos.writeObject(cont.getValue("Header"));
                }
            } else {
                oos.writeObject(this.m_InputToken.getPayload());
            }
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            result = this.handleException("Failed to serialize model data to '" + this.m_OutputFile + "':", e);
        }
        return result;
    }
}

