/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.container.WekaModelContainer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.WekaTrainClassifier;
import java.util.Hashtable;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Instance;
import weka.core.Instances;

@Deprecated
public class WekaClassifier
extends AbstractTransformer {
    private static final long serialVersionUID = -3019442578354930841L;
    public static final String BACKUP_INCREMENTALCLASSIFIER = "incremental classifier";
    protected Classifier m_Classifier;
    protected Classifier m_IncrementalClassifier;

    public String globalInfo() {
        return "Trains a classifier based on the incoming dataset and outputs the built classifier alongside the training header (in a model container).\nIncremental training is performed, if the input are weka.core.Instance objects and the classifier implements " + UpdateableClassifier.class.getName() + ".\n" + "If the incoming token does not encapsulate a dataset or instance, then " + "only a new instance of the classifier is sent around.\n\n" + "DEPRECATED\n\n" + "- Use " + WekaClassifierSetup.class.getName() + " for definined a classifier setup.\n" + "- Use " + WekaTrainClassifier.class.getName() + " for building a classifier.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new ZeroR());
    }

    public void setClassifier(Classifier value) {
        this.m_Classifier = value;
        this.reset();
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The Weka classifier to train on the input data.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("classifier");
        if (variable != null) {
            return variable;
        }
        if (this.m_Classifier != null) {
            return this.m_Classifier.getClass().getName().replace("weka.classifiers.", "");
        }
        return null;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_INCREMENTALCLASSIFIER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_IncrementalClassifier != null) {
            result.put(BACKUP_INCREMENTALCLASSIFIER, this.m_IncrementalClassifier);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INCREMENTALCLASSIFIER)) {
            this.m_IncrementalClassifier = (Classifier)state.get(BACKUP_INCREMENTALCLASSIFIER);
            state.remove(BACKUP_INCREMENTALCLASSIFIER);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_IncrementalClassifier = null;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class, Instance.class, Unknown.class};
    }

    public Class[] generates() {
        return new Class[]{WekaModelContainer.class, Classifier.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instances) {
                Instances data = (Instances)this.m_InputToken.getPayload();
                Classifier cls = AbstractClassifier.makeCopy((Classifier)this.m_Classifier);
                cls.buildClassifier(data);
                this.m_OutputToken = new Token((Object)new WekaModelContainer(cls, new Instances(data, 0), data));
            } else if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instance) {
                if (!(this.m_Classifier instanceof UpdateableClassifier)) {
                    result = this.m_Classifier.getClass().getName() + " is not an incremental classifier!";
                } else {
                    Instance inst = (Instance)this.m_InputToken.getPayload();
                    if (this.m_IncrementalClassifier == null) {
                        this.m_IncrementalClassifier = AbstractClassifier.makeCopy((Classifier)this.m_Classifier);
                        Instances data = new Instances(inst.dataset(), 1);
                        data.add((Instance)inst.copy());
                        this.m_IncrementalClassifier.buildClassifier(data);
                    } else {
                        ((UpdateableClassifier)this.m_IncrementalClassifier).updateClassifier(inst);
                    }
                    this.m_OutputToken = new Token((Object)new WekaModelContainer(this.m_IncrementalClassifier, new Instances(inst.dataset(), 0)));
                }
            } else {
                Classifier cls = AbstractClassifier.makeCopy((Classifier)this.m_Classifier);
                this.m_OutputToken = new Token((Object)cls);
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process data:", e);
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_IncrementalClassifier = null;
    }
}

