/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.meta.GridSearch;
import weka.classifiers.meta.MultiSearch;
import weka.core.Instances;

public class WekaClassifierOptimizer
extends AbstractTransformer {
    private static final long serialVersionUID = -3601873599767767806L;
    protected Classifier m_Optimizer;

    public String globalInfo() {
        return "Evaluates a classifier optimizer on an incoming dataset. The best setup (untrained) found is then forwarded.\nAt the moment, only GridSearch and MultiSearch are supported as optimizers.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("optimizer", "optimizer", (Object)new GridSearch());
    }

    public String classifierTipText() {
        return "The global classifier actor to cross-validate on the input data.";
    }

    public void setOptimizer(Classifier value) {
        if (value instanceof GridSearch || value instanceof MultiSearch) {
            this.m_Optimizer = value;
            this.reset();
        } else {
            this.getSystemErr().println("Only GridSearch and MultiSearch are currently supported, provided: " + value.getClass().getName() + "!");
        }
    }

    public Classifier getOptimizer() {
        return this.m_Optimizer;
    }

    public String optimizerTipText() {
        return "The classifier optimizer to use, eg, GridSearch or MultiSearch.";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{Classifier.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            FilteredClassifier best;
            Instances data = (Instances)this.m_InputToken.getPayload();
            Classifier cls = AbstractClassifier.makeCopy((Classifier)this.m_Optimizer);
            cls.buildClassifier(data);
            if (cls instanceof GridSearch) {
                best = new FilteredClassifier();
                best.setClassifier(((GridSearch)cls).getBestClassifier());
                best.setFilter(((GridSearch)cls).getBestFilter());
            } else if (cls instanceof MultiSearch) {
                best = ((MultiSearch)cls).getBestClassifier();
            } else {
                best = null;
                result = "Unhandled optimizer: " + this.m_Optimizer.getClass().getName();
            }
            if (best != null) {
                this.m_OutputToken = new Token((Object)best);
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to optimize: ", e);
        }
        return result;
    }
}

