/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.instance.Instance;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractWekaInstanceAndWekaInstancesTransformer;
import java.util.Hashtable;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.unsupervised.attribute.Add;

public class WekaStreamFilter
extends AbstractWekaInstanceAndWekaInstancesTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 9078845385089445202L;
    public static final String BACKUP_INITIALIZED = "initialized";
    protected StreamableFilter m_Filter;
    protected boolean m_KeepRelationName;
    protected boolean m_Initialized;

    public String globalInfo() {
        return "Filters Instance objects using the specified filter.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new Add());
        this.m_OptionManager.add("keep", "keepRelationName", (Object)false);
    }

    public void setFilter(StreamableFilter value) {
        this.m_Filter = value;
        this.reset();
    }

    public StreamableFilter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The stream filter to use for filtering the Instance objects.";
    }

    public void setKeepRelationName(boolean value) {
        this.m_KeepRelationName = value;
        this.reset();
    }

    public boolean getKeepRelationName() {
        return this.m_KeepRelationName;
    }

    public String keepRelationNameTipText() {
        return "If set to true, then the filter won't change the relation name of the incoming dataset.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("filter");
        String result = variable != null ? variable : this.m_Filter.getClass().getSimpleName();
        if (this.m_KeepRelationName) {
            result = result + ", keep relation name";
        }
        return result;
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_INITIALIZED, this.m_Initialized);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INITIALIZED)) {
            this.m_Initialized = (Boolean)state.get(BACKUP_INITIALIZED);
            state.remove(BACKUP_INITIALIZED);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_Initialized = false;
    }

    protected String doExecute() {
        String result = null;
        weka.core.Instance inst = null;
        Filter filter = (Filter)this.m_Filter;
        inst = this.m_InputToken.getPayload() instanceof weka.core.Instance ? (weka.core.Instance)this.m_InputToken.getPayload() : ((Instance)((Object)this.m_InputToken.getPayload())).toInstance();
        try {
            if (!this.m_Initialized) {
                filter.setInputFormat(new Instances(inst.dataset(), 0));
            }
            String relation = inst.dataset().relationName();
            filter.input(inst);
            filter.batchFinished();
            weka.core.Instance filteredInst = filter.output();
            if (this.m_KeepRelationName) {
                filteredInst.dataset().setRelationName(relation);
            }
            if (this.m_InputToken.getPayload() instanceof weka.core.Instance) {
                this.m_OutputToken = new Token((Object)filteredInst);
            } else {
                Instance instA = new Instance();
                instA.set(filteredInst);
                this.m_OutputToken = new Token((Object)instA);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to filter data: ", e);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

