/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.data.instance.Instance;
import adams.data.instance.InstancePoint;
import adams.data.instance.InstanceUtils;
import adams.data.sequence.XYSequencePoint;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.container.AbstractDataContainerPaintlet;
import adams.gui.visualization.container.ColorContainer;
import adams.gui.visualization.container.Container;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.core.AntiAliasingPaintlet;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.instance.InstancePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.List;

public class InstanceLinePaintlet
extends AbstractDataContainerPaintlet
implements AntiAliasingPaintlet {
    private static final long serialVersionUID = -2971846774962333662L;
    protected int m_MarkerExtent;
    protected boolean m_MarkersEnabled;
    protected boolean m_AntiAliasingEnabled;

    public String globalInfo() {
        return "Paintlet for generating a line plot for Instance objects.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("markers-extent", "markerExtent", (Object)GUIHelper.getInteger(((Object)((Object)this)).getClass(), (String)"markersExtent", (Integer)7), (Number)0, null);
        this.m_OptionManager.add("markers-disabled", "markersDisabled", (Object)(GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"markersEnabled", (Boolean)true) == false ? 1 : 0));
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
    }

    public InstancePanel getInstancePanel() {
        return (InstancePanel)this.m_Panel;
    }

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.PAINT;
    }

    public Color getColor(int index) {
        Color result = Color.BLUE;
        Container cont = this.getDataContainerPanel().getContainerManager().get(index);
        if (cont instanceof ColorContainer) {
            result = ((ColorContainer)cont).getColor();
        }
        return result;
    }

    public boolean isMarkersDisabled() {
        return !this.m_MarkersEnabled;
    }

    public void setMarkersDisabled(boolean value) {
        this.m_MarkersEnabled = !value;
        this.memberChanged();
    }

    public String markersDisabledTipText() {
        return "If set to true, the markers are disabled.";
    }

    public void setMarkerExtent(int value) {
        if (value >= 0) {
            this.m_MarkerExtent = value;
            this.memberChanged();
        } else {
            System.err.println("Marker extent must be >= 0 (provided: " + value + ")!");
        }
    }

    public int getMarkerExtent() {
        return this.m_MarkerExtent;
    }

    public String markersExtentTipText() {
        return "The size of the markers in pixels.";
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    protected void drawData(Graphics g, Instance data, Color color, MarkerShape marker) {
        int end;
        List points = data.toList();
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        g.setColor(color);
        if (this.m_AntiAliasingEnabled) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        int start = InstanceUtils.findClosestX(points, (int)Math.floor(axisX.getMinimum()));
        if (start > 0) {
            --start;
        }
        if ((end = InstanceUtils.findClosestX(points, (int)Math.ceil(axisX.getMaximum()))) < data.size() - 1) {
            ++end;
        }
        int currX = Integer.MIN_VALUE;
        int currY = Integer.MIN_VALUE;
        int prevMarkerX = 0;
        int prevMarkerY = 0;
        int prevX = axisX.valueToPos((double)((InstancePoint)((Object)points.get(start))).getX().intValue());
        int prevY = axisY.valueToPos(((InstancePoint)((Object)points.get(start))).getY().doubleValue());
        for (int i = start; i <= end; ++i) {
            InstancePoint curr = (InstancePoint)((Object)points.get(i));
            currX = axisX.valueToPos(XYSequencePoint.toDouble((Integer)curr.getX()).doubleValue());
            if (i != start && i != end && currX == prevX) continue;
            currY = axisY.valueToPos(XYSequencePoint.toDouble((Double)curr.getY()).doubleValue());
            g.drawLine(prevX, prevY, currX, currY);
            if (marker != MarkerShape.NONE && Math.sqrt(Math.pow(currX - prevMarkerX, 2.0) + Math.pow(currY - prevMarkerY, 2.0)) > (double)(this.m_MarkerExtent * 2)) {
                if (marker == MarkerShape.BOX) {
                    g.drawRect(currX - this.m_MarkerExtent / 2, currY - this.m_MarkerExtent / 2, this.m_MarkerExtent - 1, this.m_MarkerExtent - 1);
                } else if (marker == MarkerShape.CIRCLE) {
                    g.drawArc(currX - this.m_MarkerExtent / 2, currY - this.m_MarkerExtent / 2, this.m_MarkerExtent - 1, this.m_MarkerExtent - 1, 0, 360);
                } else if (marker == MarkerShape.TRIANGLE) {
                    int[] x = new int[3];
                    int[] y = new int[3];
                    x[0] = currX - this.m_MarkerExtent / 2;
                    y[0] = currY + this.m_MarkerExtent / 2;
                    x[1] = x[0] + this.m_MarkerExtent;
                    y[1] = y[0];
                    x[2] = currX;
                    y[2] = y[0] - this.m_MarkerExtent;
                    g.drawPolygon(x, y, 3);
                }
                prevMarkerX = currX;
                prevMarkerY = currY;
            }
            prevX = currX;
            prevY = currY;
        }
    }

    protected MarkerShape getMarkerShape(int index) {
        MarkerShape result = MarkerShape.NONE;
        if (this.m_MarkersEnabled && this.m_MarkerExtent > 0 && this.getPlot().isZoomed()) {
            MarkerShape[] shapes = MarkerShape.values();
            result = shapes[index % (shapes.length - 1) + 1];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        ContainerManager manager;
        ContainerManager containerManager = manager = this.getDataContainerPanel().getContainerManager();
        synchronized (containerManager) {
            for (int i = 0; i < manager.count(); ++i) {
                Instance data;
                Container cont = manager.get(i);
                if (cont instanceof VisibilityContainer && !((VisibilityContainer)cont).isVisible()) continue;
                Instance instance = data = (Instance)((Object)cont.getPayload());
                synchronized (instance) {
                    this.drawData(g, data, this.getColor(i), this.getMarkerShape(i));
                    continue;
                }
            }
        }
    }

    public static enum MarkerShape {
        NONE,
        BOX,
        CIRCLE,
        TRIANGLE;

    }
}

