/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.predictions;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.option.OptionUtils;
import adams.data.weka.predictions.AbstractErrorScaler;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractErrorScalerTestCase
extends AdamsTestCase {
    public AbstractErrorScalerTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/weka/predictions/data");
    }

    protected ArrayList load(String filename, boolean containsDoubles) {
        this.m_TestHelper.copyResourceToTmp(filename);
        ArrayList<Number> result = new ArrayList<Number>();
        List list = FileUtils.loadFromFile((File)new TmpFile(filename));
        for (int i = 0; i < list.size(); ++i) {
            if (containsDoubles) {
                result.add(Utils.toDouble((String)((String)list.get(i))));
                continue;
            }
            result.add(Integer.parseInt((String)list.get(i)));
        }
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract boolean[] getRegressionInputFileContainDoubles();

    protected abstract AbstractErrorScaler[] getRegressionSetups();

    protected ArrayList<Integer> process(ArrayList data, AbstractErrorScaler scheme) {
        return scheme.scale(data);
    }

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    protected boolean save(ArrayList<Integer> data, String filename) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < data.size(); ++i) {
            list.add(Integer.toString(data.get(i)));
        }
        return FileUtils.saveToFile(list, (File)new TmpFile(filename));
    }

    public void testRegression() {
        int i;
        String[] input = this.getRegressionInputFiles();
        boolean[] doubles = this.getRegressionInputFileContainDoubles();
        String[] output = new String[input.length];
        AbstractErrorScaler[] setups = this.getRegressionSetups();
        AbstractErrorScalerTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        AbstractErrorScalerTestCase.assertEquals((String)"Number of files and whether they contain doubles differ!", (int)input.length, (int)doubles.length);
        for (i = 0; i < input.length; ++i) {
            ArrayList data = this.load(input[i], doubles[i]);
            AbstractErrorScalerTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), (Object)data);
            AbstractErrorScaler current = setups[i].shallowCopy();
            AbstractErrorScalerTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            ArrayList<Integer> processed = this.process(data, current);
            AbstractErrorScalerTestCase.assertNotNull((String)"Failed to process data?", processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractErrorScalerTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractErrorScalerTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

