/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.ContainerValuePicker;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaTrainClassifier;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;

public class ContainerValuePickerTest
extends AbstractFlowTest {
    public ContainerValuePickerTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_all.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_model.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_all.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile_model.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        GlobalActors ga = new GlobalActors();
        WekaClassifierSetup wcs = new WekaClassifierSetup();
        wcs.setName("cls");
        wcs.setClassifier((Classifier)new J48());
        ga.add((AbstractActor)wcs);
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("vote.arff")});
        WekaFileReader fr = new WekaFileReader();
        WekaClassSelector cs = new WekaClassSelector();
        WekaTrainClassifier cls = new WekaTrainClassifier();
        cls.setClassifier(new GlobalActorReference("cls"));
        DumpFile df_model = new DumpFile();
        df_model.setOutputFile((PlaceholderFile)new TmpFile("dumpfile_model.txt"));
        ContainerValuePicker cvp = new ContainerValuePicker();
        cvp.setValueName("Model");
        cvp.add(0, (AbstractActor)df_model);
        DumpFile df_all = new DumpFile();
        df_all.setOutputFile((PlaceholderFile)new TmpFile("dumpfile_all.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, fr, cs, cls, cvp, df_all});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile_all.txt"), new TmpFile("dumpfile_model.txt")});
    }

    public static Test suite() {
        return new TestSuite(ContainerValuePickerTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ContainerValuePickerTest.runTest((Test)ContainerValuePickerTest.suite());
    }
}

