/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.source.FileSupplier;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.GlobalTransformer;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaFilter;
import adams.flow.transformer.WekaInstanceDumper;
import adams.flow.transformer.WekaRenameRelation;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;
import weka.filters.unsupervised.attribute.Remove;

public class GlobalTransformerTest
extends AbstractFlowTest {
    public GlobalTransformerTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile1.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile2.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile1.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile2.arff");
        super.tearDown();
    }

    public AbstractActor getActor() {
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("vote.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.INCREMENTAL);
        WekaFilter wf = new WekaFilter();
        wf.setInitializeOnce(false);
        wf.setFilter((Filter)new Add());
        wf.setName("global-wf");
        GlobalActors gas = new GlobalActors();
        gas.setActors(new AbstractActor[]{wf});
        WekaFilter wf1 = new WekaFilter();
        Remove rem1 = new Remove();
        rem1.setAttributeIndices("1");
        wf1.setFilter((Filter)rem1);
        GlobalTransformer gt1 = new GlobalTransformer();
        gt1.setGlobalName(new GlobalActorReference("global-wf"));
        WekaRenameRelation ren1 = new WekaRenameRelation();
        ren1.setFind("[\\s\\S]+");
        ren1.setReplace("blah1");
        WekaInstanceDumper id1 = new WekaInstanceDumper();
        id1.setOutputPrefix((PlaceholderFile)new TmpFile("dumpfile1"));
        Sequence sq1 = new Sequence();
        sq1.setActors(new AbstractActor[]{wf1, gt1, ren1, id1});
        WekaFilter wf2 = new WekaFilter();
        Remove rem2 = new Remove();
        rem2.setAttributeIndices("2");
        wf2.setFilter((Filter)rem2);
        GlobalTransformer gt2 = new GlobalTransformer();
        gt2.setGlobalName(new GlobalActorReference("global-wf"));
        WekaRenameRelation ren2 = new WekaRenameRelation();
        ren2.setFind("[\\s\\S]+");
        ren2.setReplace("blah2");
        WekaInstanceDumper id2 = new WekaInstanceDumper();
        id2.setOutputPrefix((PlaceholderFile)new TmpFile("dumpfile2"));
        Sequence sq2 = new Sequence();
        sq2.setActors(new AbstractActor[]{wf2, gt2, ren2, id2});
        Branch br = new Branch();
        br.setBranches(new AbstractActor[]{sq1, sq2});
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{gas, sfs, fr, br});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile1.arff"), new TmpFile("dumpfile2.arff")});
    }

    public static Test suite() {
        return new TestSuite(GlobalTransformerTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        GlobalTransformerTest.runTest((Test)GlobalTransformerTest.suite());
    }
}

