/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayStandardScores;
import adams.data.statistics.MultiArrayStatistic;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.ArrayToSequence;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaCrossValidationEvaluator;
import adams.flow.transformer.WekaExtractArray;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaInstancesStatistic;
import adams.flow.transformer.WekaPredictionsToInstances;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegression;

public class WekaExtractArrayTest
extends AbstractFlowTest {
    public WekaExtractArrayTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        WekaClassifierSetup cl = new WekaClassifierSetup();
        cl.setName("cl");
        cl.setClassifier((Classifier)new LinearRegression());
        GlobalActors ga = new GlobalActors();
        ga.setActors(new AbstractActor[]{cl});
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("bolts.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.DATASET);
        WekaClassSelector cs = new WekaClassSelector();
        WekaCrossValidationEvaluator cv = new WekaCrossValidationEvaluator();
        cv.setClassifier(new GlobalActorReference("cl"));
        WekaPredictionsToInstances p2i = new WekaPredictionsToInstances();
        MultiArrayStatistic mas = new MultiArrayStatistic();
        mas.setSubStatistics(new AbstractArrayStatistic[]{new ArrayStandardScores()});
        WekaInstancesStatistic is = new WekaInstancesStatistic();
        is.setDataType(WekaInstancesStatistic.DataType.COLUMN_BY_REGEXP);
        is.setLocations(new BaseString[]{new BaseString("Predicted")});
        is.setStatistic((AbstractArrayStatistic)mas);
        WekaExtractArray ea = new WekaExtractArray();
        ea.setType(WekaExtractArray.ExtractionType.COLUMN);
        ea.setIndex(new Index("1"));
        ArrayToSequence a2s = new ArrayToSequence();
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, fr, cs, cv, p2i, is, ea, a2s, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(WekaExtractArrayTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaExtractArrayTest.runTest((Test)WekaExtractArrayTest.suite());
    }
}

