/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.SequencePlotter;
import adams.flow.sink.sequenceplotter.AbstractSequencePostProcessor;
import adams.flow.sink.sequenceplotter.SimplePruning;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaInstanceStreamPlotGenerator;
import adams.gui.visualization.sequence.XYSequenceLinePaintlet;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class WekaInstanceStreamPlotGeneratorTest
extends AbstractFlowTest {
    public WekaInstanceStreamPlotGeneratorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.arff");
        super.tearDown();
    }

    public AbstractActor getActor() {
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("bolts.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.INCREMENTAL);
        WekaInstanceStreamPlotGenerator ispg = new WekaInstanceStreamPlotGenerator();
        ispg.setAttributes(new Range("1-7"));
        SequencePlotter sp = new SequencePlotter();
        SimplePruning pruning = new SimplePruning();
        pruning.setLimit(30);
        sp.setPostProcessor((AbstractSequencePostProcessor)pruning);
        sp.setPaintlet((XYSequencePaintlet)new XYSequenceLinePaintlet());
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, fr, ispg, sp});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(WekaInstanceStreamPlotGeneratorTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaInstanceStreamPlotGeneratorTest.runTest((Test)WekaInstanceStreamPlotGeneratorTest.suite());
    }
}

