/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.sink.GlobalSink;
import adams.flow.source.FileSupplier;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaRegexToRange;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class WekaRegexToRangeTest
extends AbstractFlowTest {
    public WekaRegexToRangeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        this.m_TestHelper.copyResourceToTmp("labor.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        this.m_TestHelper.deleteFileFromTmp("labor.arff");
        super.tearDown();
    }

    public AbstractActor getActor() {
        DumpFile df = new DumpFile();
        df.setName("out");
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        GlobalActors ga = new GlobalActors();
        ga.setActors(new AbstractActor[]{df});
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("labor.arff")});
        WekaFileReader fr = new WekaFileReader();
        WekaRegexToRange rtr1 = new WekaRegexToRange();
        GlobalSink gs1 = new GlobalSink();
        gs1.setGlobalName(new GlobalActorReference("out"));
        Sequence s1 = new Sequence();
        s1.setActors(new AbstractActor[]{rtr1, gs1});
        WekaRegexToRange rtr2 = new WekaRegexToRange();
        rtr2.setRegex("wage-.*");
        GlobalSink gs2 = new GlobalSink();
        gs2.setGlobalName(new GlobalActorReference("out"));
        Sequence s2 = new Sequence();
        s2.setActors(new AbstractActor[]{rtr2, gs2});
        Branch br = new Branch();
        br.setNumThreads(0);
        br.setBranches(new AbstractActor[]{s1, s2});
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, fr, br});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(WekaRegexToRangeTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaRegexToRangeTest.runTest((Test)WekaRegexToRangeTest.suite());
    }
}

