/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.converters.ArffLoader;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.RemoveDuplicates;
import weka.test.AdamsTestHelper;

public class RemoveDuplicatesTest
extends AbstractAdamsFilterTest {
    public RemoveDuplicatesTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ArffLoader loader = new ArffLoader();
        loader.setSource(ClassLoader.getSystemResource("weka/filters/data/bolts_duplicates.arff"));
        this.m_Instances = loader.getDataSet();
        this.m_Instances.setClassIndex(this.m_Instances.numAttributes() - 1);
    }

    protected Instances getFilteredClassifierData() {
        return null;
    }

    public void testFilteredClassifier() {
    }

    public Filter getFilter() {
        return new RemoveDuplicates();
    }

    public Filter getFilter(boolean inclClass, boolean randomize) {
        RemoveDuplicates result = new RemoveDuplicates();
        result.setIncludeClass(inclClass);
        result.setRandomize(randomize);
        return result;
    }

    protected void performTest() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RemoveDuplicatesTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            RemoveDuplicatesTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            RemoveDuplicatesTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        RemoveDuplicatesTest.assertEquals((String)"Number of attributes", (int)icopy.numAttributes(), (int)result.numAttributes());
        RemoveDuplicatesTest.assertTrue((String)"Removal of instances", (icopy.numInstances() != result.numInstances() ? 1 : 0) != 0);
    }

    public void testDefault() {
        this.m_Filter = this.getFilter();
        this.testBuffered();
        this.performTest();
    }

    public void testIncludeClass() {
        this.m_Filter = this.getFilter(true, false);
        this.testBuffered();
        this.performTest();
    }

    public void testRandomize() {
        this.m_Filter = this.getFilter(false, true);
        this.testBuffered();
        this.performTest();
    }

    public static Test suite() {
        return new TestSuite(RemoveDuplicatesTest.class);
    }

    public static void main(String[] args) {
        AdamsTestHelper.setRegressionRoot();
        TestRunner.run((Test)RemoveDuplicatesTest.suite());
    }
}

