/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DataRowType;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.util.Date;
import weka.core.Instances;

public class WekaInstancesToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = -7728745365733721265L;
    protected DataRowType m_DataRowType;

    public String globalInfo() {
        return "Generates a spreadsheet from a weka.core.Instances object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-row-type", "dataRowType", (Object)DataRowType.DENSE);
    }

    public void setDataRowType(DataRowType value) {
        this.m_DataRowType = value;
        this.reset();
    }

    public DataRowType getDataRowType() {
        return this.m_DataRowType;
    }

    public String dataRowTypeTipText() {
        return "The type of row to use for the data.";
    }

    public Class accepts() {
        return Instances.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        int n;
        Instances data = (Instances)this.m_Input;
        SpreadSheet result = new SpreadSheet();
        result.setDataRowClass(this.m_DataRowType.getRowClass());
        HeaderRow row = result.getHeaderRow();
        for (n = 0; n < data.numAttributes(); ++n) {
            row.addCell("" + n).setContent(data.attribute(n).name());
        }
        for (int i = 0; i < data.numInstances(); ++i) {
            row = result.addRow("" + i);
            for (n = 0; n < data.numAttributes(); ++n) {
                if (data.instance(i).isMissing(n)) continue;
                if (data.attribute(n).type() == 3) {
                    row.addCell("" + n).setContent(new Date((long)data.instance(i).value(n)));
                    continue;
                }
                if (data.attribute(n).type() == 0) {
                    row.addCell("" + n).setContent(Double.valueOf(data.instance(i).value(n)));
                    continue;
                }
                String str = data.instance(i).stringValue(n);
                if (str.equals("?")) {
                    row.addCell("" + n).setContentAsString("'" + str + "'");
                    continue;
                }
                row.addCell("" + n).setContentAsString(str);
            }
        }
        return result;
    }
}

