/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.WekaPredictionContainer;
import java.util.Collections;
import java.util.Vector;
import weka.core.Instance;

public class WekaPredictionContainerToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = 124581970397295630L;
    public static final String PLACEHOLDER_LABEL = "{LABEL}";
    public static final String PLACEHOLDER_INDEX = "{INDEX}";
    public static final String COLUMN_NAME = "Name";
    public static final String COLUMN_VALUE = "Value";
    protected String m_TitleNameColumn;
    protected String m_TitleValueColumn;
    protected boolean m_AddClassification;
    protected String m_ClassificationEntry;
    protected boolean m_AddClassificationLabel;
    protected String m_ClassificationLabelEntry;
    protected boolean m_AddDistribution;
    protected String m_DistributionFormat;
    protected Sorting m_DistributionSorting;

    public String globalInfo() {
        return "Turns a WEKA prediction container into a SpreadSheet object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("title-name-column", "titleNameColumn", (Object)COLUMN_NAME);
        this.m_OptionManager.add("title-value-column", "titleValueColumn", (Object)COLUMN_VALUE);
        this.m_OptionManager.add("add-classification", "addClassification", (Object)false);
        this.m_OptionManager.add("classification-entry", "classificationEntry", (Object)"Classification");
        this.m_OptionManager.add("add-classification-label", "addClassificationLabel", (Object)false);
        this.m_OptionManager.add("classification-label-entry", "classificationLabelEntry", (Object)"Class");
        this.m_OptionManager.add("add-distribution", "addDistribution", (Object)false);
        this.m_OptionManager.add("distribution-format", "distributionFormat", (Object)PLACEHOLDER_LABEL);
        this.m_OptionManager.add("distribution-sorting", "distributionSorting", (Object)Sorting.NONE);
    }

    public void setTitleNameColumn(String value) {
        this.m_TitleNameColumn = value;
        this.reset();
    }

    public String getTitleNameColumn() {
        return this.m_TitleNameColumn;
    }

    public String titleNameColumnTipText() {
        return "The title of the first column.";
    }

    public void setTitleValueColumn(String value) {
        this.m_TitleValueColumn = value;
        this.reset();
    }

    public String getTitleValueColumn() {
        return this.m_TitleValueColumn;
    }

    public String titleValueColumnTipText() {
        return "The title of the second column.";
    }

    public void setAddClassification(boolean value) {
        this.m_AddClassification = value;
        this.reset();
    }

    public boolean getAddClassification() {
        return this.m_AddClassification;
    }

    public String addClassificationTipText() {
        return "If enabled, then the numeric classification (index of class label for nominal classes) is added to the spreadsheet.";
    }

    public void setClassificationEntry(String value) {
        this.m_ClassificationEntry = value;
        this.reset();
    }

    public String getClassificationEntry() {
        return this.m_ClassificationEntry;
    }

    public String classificationEntryTipText() {
        return "The value to use in the 'Name' column for the numeric classification.";
    }

    public void setAddClassificationLabel(boolean value) {
        this.m_AddClassificationLabel = value;
        this.reset();
    }

    public boolean getAddClassificationLabel() {
        return this.m_AddClassificationLabel;
    }

    public String addClassificationLabelTipText() {
        return "If enabled, then the classification label (only for nominal classes) is added to the spreadsheet.";
    }

    public void setClassificationLabelEntry(String value) {
        this.m_ClassificationLabelEntry = value;
        this.reset();
    }

    public String getClassificationLabelEntry() {
        return this.m_ClassificationLabelEntry;
    }

    public String classificationLabelEntryTipText() {
        return "The value to use in the 'Name' column for the classification label.";
    }

    public void setAddDistribution(boolean value) {
        this.m_AddDistribution = value;
        this.reset();
    }

    public boolean getAddDistribution() {
        return this.m_AddDistribution;
    }

    public String addDistributionTipText() {
        return "If enabled, then the class distribution (only for nominal classes) is added to the spreadsheet.";
    }

    public void setDistributionFormat(String value) {
        this.m_DistributionFormat = value;
        this.reset();
    }

    public String getDistributionFormat() {
        return this.m_DistributionFormat;
    }

    public String distributionFormatTipText() {
        return "The format to use in the 'Name' column for the class distribution; '{INDEX}' can be used for the 1-based index, '{LABEL}' can be used for the class label (if available; if not, the 1-based index is used instead)";
    }

    public void setDistributionSorting(Sorting value) {
        this.m_DistributionSorting = value;
        this.reset();
    }

    public Sorting getDistributionSorting() {
        return this.m_DistributionSorting;
    }

    public String distributionSortingTipText() {
        return "The type of sorting to apply to the distribution array.";
    }

    public Class accepts() {
        return WekaPredictionContainer.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        SpreadSheet result = new SpreadSheet();
        WekaPredictionContainer cont = (WekaPredictionContainer)((Object)this.m_Input);
        HeaderRow row = result.getHeaderRow();
        row.addCell(COLUMN_NAME).setContent(this.m_TitleNameColumn);
        row.addCell(COLUMN_VALUE).setContent(this.m_TitleValueColumn);
        if (this.m_AddClassification && cont.hasValue("Classification")) {
            row = result.addRow("" + result.getRowCount());
            row.addCell(COLUMN_NAME).setContent(this.m_ClassificationEntry);
            row.addCell(COLUMN_VALUE).setContent((Double)cont.getValue("Classification"));
        }
        if (this.m_AddClassificationLabel && cont.hasValue("Classification label")) {
            row = result.addRow("" + result.getRowCount());
            row.addCell(COLUMN_NAME).setContent(this.m_ClassificationLabelEntry);
            row.addCell(COLUMN_VALUE).setContent((String)cont.getValue("Classification label"));
        }
        if (this.m_AddDistribution && cont.hasValue("Distribution")) {
            int i;
            double[] dist = (double[])cont.getValue("Distribution");
            int[] distIndex = new int[dist.length];
            for (i = 0; i < dist.length; ++i) {
                distIndex[i] = i;
            }
            if (this.m_DistributionSorting != Sorting.NONE) {
                Vector<SortContainer> dists = new Vector<SortContainer>();
                for (i = 0; i < dist.length; ++i) {
                    if (this.m_DistributionSorting == Sorting.DESCENDING) {
                        dists.add(new SortContainer(distIndex[i], 1.0 - dist[i]));
                        continue;
                    }
                    dists.add(new SortContainer(distIndex[i], dist[i]));
                }
                Collections.sort(dists);
                double[] distSorted = new double[dist.length];
                for (i = 0; i < dists.size(); ++i) {
                    distSorted[i] = dist[((SortContainer)dists.get(i)).getIndex()];
                    distIndex[i] = ((SortContainer)dists.get(i)).getIndex();
                }
                dist = distSorted;
            }
            Instance inst = (Instance)cont.getValue("Instance");
            for (i = 0; i < dist.length; ++i) {
                String entry = this.m_DistributionFormat;
                entry = entry.replace(PLACEHOLDER_INDEX, "" + (distIndex[i] + 1));
                String label = inst == null ? "" + (distIndex[i] + 1) : inst.classAttribute().value(distIndex[i]);
                entry = entry.replace(PLACEHOLDER_LABEL, label);
                row = result.addRow("" + result.getRowCount());
                row.addCell(COLUMN_NAME).setContent(entry);
                row.addCell(COLUMN_VALUE).setContent(Double.valueOf(dist[i]));
            }
        }
        return result;
    }

    public static class SortContainer
    implements Comparable<SortContainer> {
        protected int m_Index;
        protected double m_Probability;

        public SortContainer(int index, double probability) {
            this.m_Index = index;
            this.m_Probability = probability;
        }

        public int getIndex() {
            return this.m_Index;
        }

        public double getProbability() {
            return this.m_Probability;
        }

        @Override
        public int compareTo(SortContainer o) {
            return new Double(this.getProbability()).compareTo(new Double(o.getProbability()));
        }

        public boolean equals(Object obj) {
            if (obj instanceof SortContainer) {
                return this.compareTo((SortContainer)obj) == 0;
            }
            return false;
        }

        public String toString() {
            return "index=" + this.m_Index + ", prob=" + this.m_Probability;
        }
    }

    public static enum Sorting {
        NONE,
        DESCENDING,
        ASCENDING;

    }
}

