/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.base.BasePassword;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionParameterHandler;
import adams.db.SQLStatement;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.source.AbstractSource;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.DatabaseLoader;

public class WekaDatabaseReader
extends AbstractSource
implements ProvenanceSupporter,
DatabaseConnectionParameterHandler {
    private static final long serialVersionUID = 1255964542481136089L;
    protected String m_URL;
    protected String m_User;
    protected BasePassword m_Password;
    protected SQLStatement m_Query;
    protected String m_Keys;
    protected boolean m_Incremental;
    protected boolean m_SparseFormat;
    protected PlaceholderFile m_CustomPropsFile;
    protected Instances m_Structure;
    protected DatabaseLoader m_Source;
    protected Instance m_NextInstance;
    protected Instances m_Data;

    public String globalInfo() {
        return "Executes a query and returns the data either in batch or incremental mode.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", (Object)DatabaseConnection.getSingleton().getDefaultURL(), false);
        this.m_OptionManager.add("user", "user", (Object)DatabaseConnection.getSingleton().getDefaultUser(), false);
        this.m_OptionManager.add("password", "password", (Object)DatabaseConnection.getSingleton().getDefaultPassword(), false);
        this.m_OptionManager.add("query", "query", (Object)new SQLStatement("select * from result0"));
        this.m_OptionManager.add("keys", "keys", (Object)"");
        this.m_OptionManager.add("incremental", "incremental", (Object)false);
        this.m_OptionManager.add("sparse-format", "sparseFormat", (Object)false);
        this.m_OptionManager.add("custom-props", "customPropsFile", (Object)new PlaceholderFile("."));
    }

    public String getQuickInfo() {
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"user", (Object)this.m_User);
        value = value == null ? "" : value + "@";
        String result = value;
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"URL", (Object)this.m_URL);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"query", (Object)this.m_Query, (String)" using ");
        value = QuickInfoHelper.toString((OptionHandler)this, (String)"customPropsFile", (Object)(this.m_CustomPropsFile.isDirectory() ? null : this.m_CustomPropsFile));
        if (value != null) {
            result = result + " (custom props: " + value + ")";
        }
        return result;
    }

    public void setURL(String value) {
        this.m_URL = value;
        this.reset();
    }

    public String getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The JDBC URL of the database to query.";
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The user for connecting to the database.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password for the database user.";
    }

    public void setQuery(SQLStatement value) {
        this.m_Query = value;
        this.reset();
    }

    public SQLStatement getQuery() {
        return this.m_Query;
    }

    public String queryTipText() {
        return "The SQL query to execute.";
    }

    public void setKeys(String value) {
        this.m_Keys = value;
        this.reset();
    }

    public String getKeys() {
        return this.m_Keys;
    }

    public String keysTipText() {
        return "The keys to use for identifying a single row (comma-separated list of column names).";
    }

    public void setIncremental(boolean value) {
        this.m_Incremental = value;
        this.reset();
    }

    public boolean getIncremental() {
        return this.m_Incremental;
    }

    public String incrementalTipText() {
        return "If set to true, then single Instance objects are output, otherwise just one Instances object.";
    }

    public void setSparseFormat(boolean value) {
        this.m_SparseFormat = value;
        this.reset();
    }

    public boolean getSparseFormat() {
        return this.m_SparseFormat;
    }

    public String sparseFormatTipText() {
        return "If set to true, the data will be output in sparse format.";
    }

    public void setCustomPropsFile(PlaceholderFile value) {
        this.m_CustomPropsFile = value;
        this.reset();
    }

    public PlaceholderFile getCustomPropsFile() {
        return this.m_CustomPropsFile;
    }

    public String customPropsFileTipText() {
        return "Custom properties file to override the default database settings, eg, for accessing a different type of database; ignored if pointing to a directory.";
    }

    public Class[] generates() {
        return new Class[]{Instance.class, Instances.class};
    }

    protected void reset() {
        super.reset();
        this.m_Structure = null;
        this.m_Source = null;
        this.m_NextInstance = null;
        this.m_Data = null;
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_Source = new DatabaseLoader();
            this.m_Source.setCustomPropsFile(this.m_CustomPropsFile.getAbsoluteFile());
            this.m_Source.setUrl(this.m_URL);
            this.m_Source.setUser(this.m_User);
            this.m_Source.setPassword(this.m_Password.getValue());
            this.m_Source.setKeys(this.m_Keys);
            this.m_Source.setQuery(this.m_Query.getValue());
            this.m_Source.setSparseData(this.m_SparseFormat);
            if (this.m_Incremental) {
                this.m_Structure = this.m_Source.getStructure();
            } else {
                this.m_Data = this.m_Source.getDataSet();
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to read from database: " + this.m_URL, e);
        }
        return result;
    }

    public Token output() {
        Token result;
        if (this.m_Incremental) {
            try {
                result = this.m_NextInstance != null ? new Token((Object)this.m_NextInstance) : new Token((Object)this.m_Source.getNextInstance(this.m_Structure));
                this.m_NextInstance = null;
            }
            catch (Exception e) {
                result = null;
                this.getSystemErr().printStackTrace((Throwable)e);
            }
            if (result == null) {
                this.m_Structure = null;
                this.m_Source = null;
            }
        } else {
            try {
                result = new Token((Object)this.m_Data);
            }
            catch (Exception e) {
                result = null;
                this.getSystemErr().printStackTrace((Throwable)e);
            }
            this.m_Source = null;
            this.m_Data = null;
        }
        if (result != null) {
            this.updateProvenance((ProvenanceContainer)result);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        boolean result = false;
        if (this.m_Incremental) {
            if (this.m_Source != null && this.m_NextInstance == null) {
                try {
                    this.m_NextInstance = this.m_Source.getNextInstance(this.m_Structure);
                }
                catch (Exception e) {
                    this.m_NextInstance = null;
                    this.getSystemErr().printStackTrace((Throwable)e);
                }
            }
            result = this.m_NextInstance != null;
        } else {
            result = this.m_Data != null;
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_Structure = null;
        this.m_Source = null;
        this.m_NextInstance = null;
        this.m_Data = null;
    }
}

