/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.EvaluationHelper;
import adams.flow.core.EvaluationStatistic;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.classifiers.Evaluation;

public class WekaEvaluationValuePicker
extends AbstractTransformer {
    private static final long serialVersionUID = -3113058781746945626L;
    protected EvaluationStatistic m_StatisticValue;
    protected int m_ClassIndex;

    public String globalInfo() {
        return "Picks a specific value from an evaluation object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statistic", "statisticValue", (Object)EvaluationStatistic.PERCENT_CORRECT);
        this.m_OptionManager.add("index", "classIndex", (Object)1);
    }

    public void setStatisticValue(EvaluationStatistic value) {
        this.m_StatisticValue = value;
        this.reset();
    }

    public EvaluationStatistic getStatisticValue() {
        return this.m_StatisticValue;
    }

    public String statisticValueTipText() {
        return "The evaluation value to extract.";
    }

    public void setClassIndex(int value) {
        this.m_ClassIndex = value;
        this.reset();
    }

    public int getClassIndex() {
        return this.m_ClassIndex;
    }

    public String classIndexTipText() {
        return "The class label index (eg used for AUC).";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"classIndex", (Object)this.m_ClassIndex);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"statisticValue", (Object)((Object)this.m_StatisticValue), (String)": ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, WekaEvaluationContainer.class};
    }

    protected String doExecute() {
        String result = null;
        double value = Double.NaN;
        Evaluation eval = this.m_InputToken.getPayload() instanceof WekaEvaluationContainer ? (Evaluation)((WekaEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Evaluation") : (Evaluation)this.m_InputToken.getPayload();
        try {
            value = EvaluationHelper.getValue(eval, this.m_StatisticValue, this.m_ClassIndex);
            this.m_OutputToken = new Token((Object)value);
        }
        catch (Exception e) {
            result = this.handleException("Error retrieving value for '" + (Object)((Object)this.m_StatisticValue) + "':\n", e);
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{Double.class};
    }
}

