/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.Storage;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.core.Instance;
import weka.core.Instances;

public class WekaStoreInstance
extends AbstractTransformer {
    private static final long serialVersionUID = 3077398394768688867L;
    protected StorageName m_Dataset;

    public String globalInfo() {
        return "Appends the incoming " + Instance.class.getName() + " to the dataset " + "in storage. If no dataset currently stored under this name, it " + "will get automatically added. The dataset after the update " + "operation is then forwarded as token.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dataset", "dataset", (Object)new StorageName());
    }

    public void setDataset(StorageName value) {
        this.m_Dataset = value;
        this.reset();
    }

    public StorageName getDataset() {
        return this.m_Dataset;
    }

    public String datasetTipText() {
        return "The name of the dataset in internal storage to append the incoming data to.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"dataset", (Object)this.m_Dataset);
    }

    public Class[] accepts() {
        return new Class[]{Instance.class};
    }

    public Class[] generates() {
        return new Class[]{Instances.class};
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && this.m_Dataset.isEmpty()) {
            result = "No storage name set for dataset!";
        }
        return result;
    }

    protected String doExecute() {
        Instances data;
        String result = null;
        Instance inst = (Instance)this.m_InputToken.getPayload();
        Storage storage = this.getStorageHandler().getStorage();
        if (!storage.has(this.m_Dataset)) {
            data = new Instances(inst.dataset(), 0);
            storage.put(this.m_Dataset, (Object)data);
            if (this.isDebugOn()) {
                this.debug("Adding dataset to storage: " + this.m_Dataset);
            }
        } else {
            data = (Instances)storage.get(this.m_Dataset);
            if (this.isDebugOn()) {
                this.debug("Dataset present in storage: " + this.m_Dataset);
            }
        }
        data.add(inst);
        storage.put(this.m_Dataset, (Object)data);
        if (this.isDebugOn()) {
            this.debug("Added instance to storage: " + this.m_Dataset);
        }
        this.m_OutputToken = new Token((Object)data);
        return result;
    }
}

