/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.WekaModelContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Instance;
import weka.core.Instances;

public class WekaTrainClassifier
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = -3019442578354930841L;
    public static final String BACKUP_INCREMENTALCLASSIFIER = "incremental classifier";
    protected GlobalActorReference m_Classifier;
    protected Classifier m_ActualClassifier;
    protected Classifier m_IncrementalClassifier;

    public String globalInfo() {
        return "Trains a classifier based on the incoming dataset and outputs the built classifier alongside the training header (in a model container).\nIncremental training is performed, if the input are weka.core.Instance objects and the classifier implements " + UpdateableClassifier.class.getName() + ".";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new GlobalActorReference(WekaClassifierSetup.class.getSimpleName()));
    }

    public void setClassifier(GlobalActorReference value) {
        this.m_Classifier = value;
        this.reset();
    }

    public GlobalActorReference getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The Weka classifier to train on the input data.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"classifier", (Object)this.m_Classifier);
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_INCREMENTALCLASSIFIER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_IncrementalClassifier != null) {
            result.put(BACKUP_INCREMENTALCLASSIFIER, this.m_IncrementalClassifier);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INCREMENTALCLASSIFIER)) {
            this.m_IncrementalClassifier = (Classifier)state.get(BACKUP_INCREMENTALCLASSIFIER);
            state.remove(BACKUP_INCREMENTALCLASSIFIER);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_IncrementalClassifier = null;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class, Instance.class};
    }

    public Class[] generates() {
        return new Class[]{WekaModelContainer.class};
    }

    protected Classifier getClassifierInstance() {
        return (Classifier)GlobalActorHelper.getSetup(Classifier.class, (GlobalActorReference)this.m_Classifier, (AbstractActor)this);
    }

    protected String doExecute() {
        String result = null;
        try {
            Classifier cls = null;
            if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instances) {
                cls = this.getClassifierInstance();
                Instances data = (Instances)this.m_InputToken.getPayload();
                cls.buildClassifier(data);
                this.m_OutputToken = new Token((Object)new WekaModelContainer(cls, new Instances(data, 0), data));
            } else if (this.m_InputToken != null && this.m_InputToken.getPayload() instanceof Instance) {
                if (this.m_IncrementalClassifier == null && !((cls = this.getClassifierInstance()) instanceof UpdateableClassifier)) {
                    result = this.m_Classifier.getClass().getName() + " is not an incremental classifier!";
                }
                if (result == null) {
                    Instance inst = (Instance)this.m_InputToken.getPayload();
                    if (this.m_IncrementalClassifier == null) {
                        this.m_IncrementalClassifier = cls;
                        Instances data = new Instances(inst.dataset(), 1);
                        data.add((Instance)inst.copy());
                        this.m_IncrementalClassifier.buildClassifier(data);
                    } else {
                        ((UpdateableClassifier)this.m_IncrementalClassifier).updateClassifier(inst);
                    }
                    this.m_OutputToken = new Token((Object)new WekaModelContainer(this.m_IncrementalClassifier, new Instances(inst.dataset(), 0)));
                }
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process data:", e);
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_IncrementalClassifier = null;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.MODEL_GENERATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

