/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.Properties;
import adams.gui.application.AbstractPropertiesPreferencesPanel;
import adams.gui.application.PreferenceType;
import adams.gui.goe.WekaGenericObjectEditorPanel;
import java.io.File;
import weka.associations.Apriori;
import weka.associations.Associator;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.BestFirst;
import weka.attributeSelection.CfsSubsetEval;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.Utils;
import weka.core.WekaPackageManager;
import weka.filters.AllFilter;
import weka.filters.Filter;

public class WekaExplorerPreferencesPanel
extends AbstractPropertiesPreferencesPanel {
    private static final long serialVersionUID = 3895159356677639564L;

    protected void initGUI() {
        super.initGUI();
        this.addPreferenceType("Tabs", PreferenceType.STRING);
        this.addPreferenceType("InitialDirectory", PreferenceType.DIRECTORY);
        this.addPreferenceType("enableUndo", PreferenceType.BOOLEAN);
        this.addPreferenceType("undoDirectory", PreferenceType.DIRECTORY);
        this.addPreferenceType("Filter", PreferenceType.OBJECT_EDITOR);
        this.setChooser("Filter", new WekaGenericObjectEditorPanel(Filter.class, new AllFilter(), true));
        this.addPreferenceType("Classifier", PreferenceType.OBJECT_EDITOR);
        this.setChooser("Classifier", new WekaGenericObjectEditorPanel(Classifier.class, new ZeroR(), true));
        this.addPreferenceType("ClassifierTestMode", PreferenceType.LIST);
        this.setList("ClassifierTestMode", new String[]{"1", "2", "3", "4"});
        this.setHelp("ClassifierTestMode", "1 - cross-validation, 2 - percentage split, 3 - use training set, 4 - supplied test set");
        this.addPreferenceType("ClassifierCrossvalidationFolds", PreferenceType.INTEGER);
        this.addPreferenceType("ClassifierPercentageSplit", PreferenceType.INTEGER);
        this.addPreferenceType("ClassifierOutputModel", PreferenceType.BOOLEAN);
        this.addPreferenceType("ClassifierOutputPerClassStats", PreferenceType.BOOLEAN);
        this.addPreferenceType("ClassifierOutputEntropyEvalMeasures", PreferenceType.BOOLEAN);
        this.addPreferenceType("ClassifierOutputConfusionMatrix", PreferenceType.BOOLEAN);
        this.addPreferenceType("ClassifierStorePredictionsForVis", PreferenceType.BOOLEAN);
        this.addPreferenceType("ClassifierOutputPredictions", PreferenceType.BOOLEAN);
        this.addPreferenceType("ClassifierOutputAdditionalAttributes", PreferenceType.STRING);
        this.addPreferenceType("ClassifierCostSensitiveEval", PreferenceType.BOOLEAN);
        this.addPreferenceType("ClassifierRandomSeed", PreferenceType.INTEGER);
        this.addPreferenceType("ClassifierPreserveOrder", PreferenceType.BOOLEAN);
        this.addPreferenceType("ClassifierOutputSourceCode", PreferenceType.BOOLEAN);
        this.addPreferenceType("ClassifierSourceCodeClass", PreferenceType.STRING);
        this.addPreferenceType("ClassifierErrorsPlotInstances", PreferenceType.STRING);
        this.addPreferenceType("ClassifierErrorsMinimumPlotSizeNumeric", PreferenceType.INTEGER);
        this.addPreferenceType("ClassifierErrorsMaximumPlotSizeNumeric", PreferenceType.INTEGER);
        this.addPreferenceType("Clusterer", PreferenceType.OBJECT_EDITOR);
        this.setChooser("Clusterer", new WekaGenericObjectEditorPanel(Clusterer.class, new SimpleKMeans(), true));
        this.addPreferenceType("ClustererTestMode", PreferenceType.LIST);
        this.setList("ClustererTestMode", new String[]{"2", "3", "4", "5"});
        this.setHelp("ClustererTestMode", "2 - percentage split, 3 - use training set, 4 - supplied test set, 5 - classes to clusters evaluation");
        this.addPreferenceType("ClustererStoreClustersForVis", PreferenceType.BOOLEAN);
        this.addPreferenceType("ClustererAssignmentsPlotInstances", PreferenceType.STRING);
        this.addPreferenceType("Associator", PreferenceType.OBJECT_EDITOR);
        this.setChooser("Associator", new WekaGenericObjectEditorPanel(Associator.class, new Apriori(), true));
        this.addPreferenceType("ASEvaluation", PreferenceType.OBJECT_EDITOR);
        this.setChooser("ASEvaluation", new WekaGenericObjectEditorPanel(ASEvaluation.class, new CfsSubsetEval(), true));
        this.addPreferenceType("ASSearch", PreferenceType.OBJECT_EDITOR);
        this.setChooser("ASSearch", new WekaGenericObjectEditorPanel(ASSearch.class, new BestFirst(), true));
        this.addPreferenceType("ASTestMode", PreferenceType.LIST);
        this.setList("ASTestMode", new String[]{"0", "1"});
        this.setHelp("ASTestMode", "0 - use full training set, 1 - cross-validation");
        this.addPreferenceType("ASCrossvalidationFolds", PreferenceType.INTEGER);
        this.addPreferenceType("ASRandomSeed", PreferenceType.INTEGER);
        try {
            this.setPreferences(new Properties(Utils.readProperties((String)"weka/gui/explorer/Explorer.props")));
        }
        catch (Exception e) {
            System.err.println("Failed to load WEKA Explorer properties:");
            e.printStackTrace();
            this.setPreferences(new Properties());
        }
    }

    public String getTitle() {
        return "WEKA Explorer";
    }

    public boolean requiresWrapper() {
        return false;
    }

    public String activate() {
        if (!WekaPackageManager.PROPERTIES_DIR.exists()) {
            WekaPackageManager.PROPERTIES_DIR.mkdirs();
            if (!WekaPackageManager.PROPERTIES_DIR.exists()) {
                return "Failed to create WEKA props directory: " + WekaPackageManager.PROPERTIES_DIR;
            }
        }
        String filename = WekaPackageManager.PROPERTIES_DIR.getAbsolutePath() + File.separator + new File("weka/gui/explorer/Explorer.props").getName();
        if (!this.getPreferences().save(filename)) {
            return "Failed to save WEKA Explorer properties: " + filename;
        }
        return null;
    }
}

