/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.instance;

import adams.core.CleanUpHandler;
import adams.core.Properties;
import adams.core.Range;
import adams.core.StatusMessageHandler;
import adams.core.io.PlaceholderFile;
import adams.data.instance.Instance;
import adams.data.statistics.ArrayHistogram;
import adams.data.statistics.InformativeStatistic;
import adams.data.weka.ArffUtils;
import adams.env.Environment;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.SearchPanel;
import adams.gui.event.DataChangeEvent;
import adams.gui.event.DataChangeListener;
import adams.gui.event.RecentFileEvent;
import adams.gui.event.RecentFileListener;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.container.ContainerListManager;
import adams.gui.visualization.container.ContainerListPopupMenuSupplier;
import adams.gui.visualization.container.ContainerTable;
import adams.gui.visualization.container.DataContainerPanel;
import adams.gui.visualization.container.NotesFactory;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.instance.HistogramFactory;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerList;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstancePanel;
import adams.gui.visualization.instance.InstanceReportFactory;
import adams.gui.visualization.instance.LoadDatasetDialog;
import adams.gui.visualization.report.ReportContainerList;
import adams.gui.visualization.report.ReportFactory;
import adams.gui.visualization.statistics.InformativeStatisticFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.core.Instances;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.ConverterUtils;
import weka.experiment.InstanceQuery;
import weka.gui.ConverterFileChooser;
import weka.gui.sql.SqlViewerDialog;

public class InstanceExplorer
extends BasePanel
implements MenuBarProvider,
StatusMessageHandler,
ContainerListManager<InstanceContainerManager>,
DataChangeListener,
PopupMenuCustomizer,
ContainerListPopupMenuSupplier<InstanceContainerManager, InstanceContainer>,
CleanUpHandler,
SendToActionSupporter {
    private static final long serialVersionUID = 4478483903068117980L;
    public static final String FILENAME = "InstanceExplorer.props";
    public static final String SESSION_FILE = "InstanceExplorerSession.props";
    protected static Properties m_Properties;
    protected InstancePanel m_PanelInstance;
    protected BaseStatusBar m_StatusBar;
    protected JMenuBar m_MenuBar;
    protected JMenu m_MenuItemLoadRecent;
    protected JMenu m_MenuView;
    protected JMenuItem m_MenuItemViewZoomOverview;
    protected JMenuItem m_MenuItemViewAntiAliasing;
    protected JMenuItem m_MenuItemClearData;
    protected BaseTabbedPane m_TabbedPane;
    protected ReportFactory.Panel m_Reports;
    protected SearchPanel m_SearchPanel;
    protected LoadDatasetDialog m_LoadFromDiskDialog;
    protected SqlViewerDialog m_LoadFromDatabaseDialog;
    protected RecentFilesHandler m_RecentFilesHandler;
    protected HistogramFactory.SetupDialog m_HistogramSetup;

    protected void initialize() {
        super.initialize();
        this.m_LoadFromDiskDialog = null;
        this.m_LoadFromDatabaseDialog = null;
        this.m_RecentFilesHandler = null;
        this.m_HistogramSetup = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new BaseTabbedPane();
        this.add((Component)this.m_TabbedPane, "Center");
        JPanel panelData = new JPanel(new BorderLayout());
        this.m_TabbedPane.addTab("Data", (Component)panelData);
        this.m_TabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ContainerTable dtable = InstanceExplorer.this.getInstanceContainerList().getTable();
                if (InstanceExplorer.this.m_TabbedPane.getSelectedIndex() == 0) {
                    ContainerTable rtable = InstanceExplorer.this.m_Reports.getReportContainerList().getTable();
                    if (rtable == null || rtable.getSelectedRowCount() != 1) {
                        return;
                    }
                    int row = rtable.getSelectedRow();
                    dtable.getSelectionModel().clearSelection();
                    dtable.getSelectionModel().setSelectionInterval(row, row);
                } else if (InstanceExplorer.this.m_TabbedPane.getSelectedIndex() == 1) {
                    if (dtable.getSelectedRowCount() != 1) {
                        return;
                    }
                    InstanceExplorer.this.m_Reports.setCurrentTable(dtable.getSelectedRow());
                }
            }
        });
        this.m_PanelInstance = new InstancePanel();
        ((InstanceContainerManager)this.m_PanelInstance.getContainerManager()).addDataChangeListener(this);
        this.m_PanelInstance.getPlot().setPopupMenuCustomizer((PopupMenuCustomizer)this);
        this.m_PanelInstance.setStatusMessageHandler(this);
        panelData.add((Component)((Object)this.m_PanelInstance), "Center");
        JPanel panelReports = new JPanel(new BorderLayout());
        this.m_TabbedPane.addTab("Information", (Component)panelReports);
        this.m_Reports = this.newReportPanel();
        this.m_Reports.setDataContainerPanel((DataContainerPanel)this.m_PanelInstance);
        panelReports.add((Component)this.m_Reports, "Center");
        this.m_SearchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_SearchPanel.addSearchListener(new SearchListener(){

            public void searchInitiated(SearchEvent e) {
                InstanceExplorer.this.m_Reports.search(InstanceExplorer.this.m_SearchPanel.getSearchText(), InstanceExplorer.this.m_SearchPanel.isRegularExpression());
                InstanceExplorer.this.m_SearchPanel.grabFocus();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_SearchPanel, "West");
        panelReports.add((Component)panel, "South");
        this.m_StatusBar = new BaseStatusBar();
        this.add((Component)this.m_StatusBar, "South");
    }

    public InstancePanel getInstancePanel() {
        return this.m_PanelInstance;
    }

    public InstanceContainerList getInstanceContainerList() {
        return this.m_PanelInstance.getInstanceContainerList();
    }

    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    protected InstanceReportFactory.Panel newReportPanel() {
        return new InstanceReportFactory.Panel();
    }

    public void dataChanged(DataChangeEvent e) {
        this.updateMenu();
    }

    public InstanceContainerManager getContainerManager() {
        return (InstanceContainerManager)this.m_PanelInstance.getContainerManager();
    }

    public void setContainerManager(InstanceContainerManager value) {
        this.m_PanelInstance.setContainerManager(value);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        boolean dataLoaded = this.getContainerManager().count() > 0;
        this.m_MenuItemClearData.setEnabled(dataLoaded);
        this.m_MenuItemLoadRecent.setEnabled(this.m_RecentFilesHandler.size() > 0);
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    InstanceExplorer.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Clear data");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed N"));
            menuitem.setIcon(GUIHelper.getIcon((String)"new.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceExplorer.this.clearData();
                }
            });
            this.m_MenuItemClearData = menuitem;
            menuitem = new JMenuItem("Load data from disk...");
            menu.add(menuitem);
            menuitem.setMnemonic('o');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceExplorer.this.loadDataFromDisk();
                }
            });
            JMenu submenu = new JMenu("Load recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler(SESSION_FILE, InstanceExplorer.getProperties().getInteger("MaxRecentFiles", Integer.valueOf(5)).intValue(), submenu);
            this.m_RecentFilesHandler.addRecentFileListener(new RecentFileListener(){

                public void recentFileAdded(RecentFileEvent e) {
                }

                public void recentFileSelected(RecentFileEvent e) {
                    InstanceExplorer.this.loadDataFromDisk(e.getFile());
                }
            });
            this.m_MenuItemLoadRecent = submenu;
            menuitem = new JMenuItem("Load data from database");
            menu.add(menuitem);
            menuitem.setMnemonic('L');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed O"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceExplorer.this.loadDataFromDatabase();
                }
            });
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JMenu)menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceExplorer.this.close();
                }
            });
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    InstanceExplorer.this.updateMenu();
                }
            });
            this.m_MenuView = menu;
            menuitem = new JCheckBoxMenuItem("Display zoom overview");
            menu.add(menuitem);
            menuitem.setMnemonic('Z');
            menuitem.setSelected(this.isZoomOverviewPanelVisible());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceExplorer.this.setZoomOverviewPanelVisible(InstanceExplorer.this.m_MenuItemViewZoomOverview.isSelected());
                }
            });
            this.m_MenuItemViewZoomOverview = menuitem;
            menuitem = new JCheckBoxMenuItem("Anti-aliasing");
            menu.add(menuitem);
            menuitem.setMnemonic('A');
            menuitem.setSelected(this.getInstancePanel().isAntiAliasingEnabled());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceExplorer.this.getInstancePanel().setAntiAliasingEnabled(InstanceExplorer.this.m_MenuItemViewAntiAliasing.isSelected());
                }
            });
            this.m_MenuItemViewAntiAliasing = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public void clearData() {
        this.getContainerManager().clear();
    }

    public void loadDataFromDatabase() {
        if (this.m_LoadFromDatabaseDialog == null) {
            this.m_LoadFromDatabaseDialog = this.getParentFrame() != null && this.getParentFrame() instanceof JFrame ? new SqlViewerDialog((JFrame)this.getParentFrame()) : new SqlViewerDialog(null);
        }
        this.m_LoadFromDatabaseDialog.setVisible(true);
        if (this.m_LoadFromDatabaseDialog.getReturnValue() != 0) {
            return;
        }
        try {
            this.showStatus("Executing query: " + this.m_LoadFromDatabaseDialog.getQuery());
            InstanceQuery query = new InstanceQuery();
            query.setDatabaseURL(this.m_LoadFromDatabaseDialog.getURL());
            query.setUsername(this.m_LoadFromDatabaseDialog.getUser());
            query.setPassword(this.m_LoadFromDatabaseDialog.getPassword());
            query.setQuery(this.m_LoadFromDatabaseDialog.getQuery());
            query.setSparseData(this.m_LoadFromDatabaseDialog.getGenerateSparseData());
            if (query.isConnected()) {
                query.disconnectFromDatabase();
            }
            query.connectToDatabase();
            this.showStatus("Loading data...");
            Vector<InstanceContainer> data = new Vector<InstanceContainer>();
            Instances dataset = query.retrieveInstances();
            for (int i = 0; i < dataset.numInstances(); ++i) {
                Instance inst = new Instance();
                inst.set(dataset.instance(i));
                inst.setID(dataset.relationName() + "." + i);
                data.add(this.getContainerManager().newContainer((Comparable)((Object)inst)));
                this.showStatus("Loading data " + (i + 1) + "/" + dataset.numInstances());
            }
            this.loadData(dataset, data);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to load data from database:\n" + e, "Database error", 0);
        }
        this.showStatus("");
    }

    public void loadDataFromDisk() {
        this.loadDataFromDisk(null);
    }

    public void loadDataFromDisk(File file) {
        if (this.m_LoadFromDiskDialog == null) {
            this.m_LoadFromDiskDialog = this.getParentDialog() != null ? new LoadDatasetDialog(this.getParentDialog()) : new LoadDatasetDialog(this.getParentFrame());
            this.m_LoadFromDiskDialog.setCurrent(new File(InstanceExplorer.getProperties().getString("InitialDir", "%h")));
            this.m_LoadFromDiskDialog.setDefaultAttributeRange(InstanceExplorer.getProperties().getString("AttributeRange", "first-last"));
            this.m_LoadFromDiskDialog.setDefaultClassIndex(InstanceExplorer.getProperties().getString("ClassIndex", ""));
            this.m_LoadFromDiskDialog.setDefaultSortIndex(InstanceExplorer.getProperties().getString("SortIndex", ""));
            this.m_LoadFromDiskDialog.setDefaultIncludeAttributes(0, InstanceExplorer.getProperties().getBoolean("IncludeNumericAttributes", Boolean.valueOf(true)));
            this.m_LoadFromDiskDialog.setDefaultIncludeAttributes(3, InstanceExplorer.getProperties().getBoolean("IncludeDateAttributes", Boolean.valueOf(false)));
            this.m_LoadFromDiskDialog.setDefaultIncludeAttributes(1, InstanceExplorer.getProperties().getBoolean("IncludeNominalAttributes", Boolean.valueOf(false)));
            this.m_LoadFromDiskDialog.setDefaultIncludeAttributes(2, InstanceExplorer.getProperties().getBoolean("IncludeStringAttributes", Boolean.valueOf(false)));
            this.m_LoadFromDiskDialog.setDefaultIncludeAttributes(4, InstanceExplorer.getProperties().getBoolean("IncludeRelationalAttributes", Boolean.valueOf(false)));
        }
        if (file != null) {
            this.m_LoadFromDiskDialog.setCurrent(file);
        }
        this.m_LoadFromDiskDialog.setVisible(true);
        int[] indices = this.m_LoadFromDiskDialog.getIndices();
        if (indices == null) {
            return;
        }
        if (this.m_RecentFilesHandler != null) {
            this.m_RecentFilesHandler.addRecentFile(this.m_LoadFromDiskDialog.getCurrent());
        }
        HashSet<Integer> attTypes = new HashSet<Integer>();
        if (this.m_LoadFromDiskDialog.getIncludeAttributes(0)) {
            attTypes.add(0);
        }
        if (this.m_LoadFromDiskDialog.getIncludeAttributes(3)) {
            attTypes.add(3);
        }
        if (this.m_LoadFromDiskDialog.getIncludeAttributes(1)) {
            attTypes.add(1);
        }
        if (this.m_LoadFromDiskDialog.getIncludeAttributes(2)) {
            attTypes.add(2);
        }
        if (this.m_LoadFromDiskDialog.getIncludeAttributes(4)) {
            attTypes.add(4);
        }
        this.showStatus("Loading data...");
        Vector<InstanceContainer> data = new Vector<InstanceContainer>();
        Instances dataset = this.m_LoadFromDiskDialog.getDataset();
        int[] additional = this.m_LoadFromDiskDialog.getAdditionalAttributes();
        Range range = this.m_LoadFromDiskDialog.getCurrentAttributeRange();
        for (int i = 0; i < indices.length; ++i) {
            Instance inst = new Instance();
            inst.set(dataset.instance(indices[i]), i, additional, range, attTypes);
            inst.setID(indices[i] + 1 + "." + dataset.relationName());
            data.add(this.getContainerManager().newContainer((Comparable)((Object)inst)));
            this.showStatus("Loading data " + (i + 1) + "/" + dataset.numInstances());
        }
        this.loadData(dataset, data);
        this.showStatus("");
    }

    protected void loadData(Instances dataset, Vector<InstanceContainer> data) {
        InstanceContainerList listInst = this.m_PanelInstance.getInstanceContainerList();
        ReportContainerList listReport = this.m_Reports.getReportContainerList();
        boolean hasDBID = dataset.attribute(ArffUtils.getDBIDName()) != null;
        listInst.setDisplayDatabaseID(hasDBID);
        listReport.setDisplayDatabaseID(hasDBID);
        this.getContainerManager().addAll(data);
    }

    public void close() {
        this.cleanUp();
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
            this.getParentFrame().dispose();
        } else if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
            this.getParentDialog().dispose();
        }
    }

    public void setSidePanelVisible(boolean visible) {
        this.m_PanelInstance.setSidePanelVisible(visible);
    }

    public boolean isSidePanelVisible() {
        return this.m_PanelInstance.isSidePanelVisible();
    }

    public JPanel getSidePanel() {
        return this.m_PanelInstance.getSidePanel();
    }

    public void setZoomOverviewPanelVisible(boolean value) {
        this.m_PanelInstance.setZoomOverviewPanelVisible(value);
    }

    public boolean isZoomOverviewPanelVisible() {
        return this.m_PanelInstance.isZoomOverviewPanelVisible();
    }

    public void customizePopupMenu(MouseEvent e, JPopupMenu menu) {
        menu.addSeparator();
        JMenuItem item = new JMenuItem();
        if (!this.getInstancePanel().getInstancePaintlet().isMarkersDisabled()) {
            item.setText("Disable markers");
        } else {
            item.setText("Enable markers");
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceExplorer.this.getInstancePanel().getInstancePaintlet().setMarkersDisabled(!InstanceExplorer.this.getInstancePanel().getInstancePaintlet().isMarkersDisabled());
                InstanceExplorer.this.repaint();
            }
        });
        menu.add(item);
        item = new JMenuItem();
        if (this.isSidePanelVisible()) {
            item.setText("Hide side panel");
        } else {
            item.setText("Show side panel");
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceExplorer.this.setSidePanelVisible(!InstanceExplorer.this.isSidePanelVisible());
            }
        });
        menu.add(item);
        item = new JMenuItem();
        if (this.getInstancePanel().getAdjustToVisibleData()) {
            item.setText("Adjust to loaded data");
        } else {
            item.setText("Adjust to visible data");
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceExplorer.this.getInstancePanel().setAdjustToVisibleData(!InstanceExplorer.this.getInstancePanel().getAdjustToVisibleData());
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Instance histogram");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceExplorer.this.showHistogram(InstanceExplorer.this.getContainerManager().getAllVisible());
            }
        });
        menu.add(item);
        item = new JMenuItem("Instance notes");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceExplorer.this.showNotes(InstanceExplorer.this.getContainerManager().getAllVisible());
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Save visible instances...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConverterFileChooser fc = new ConverterFileChooser();
                int retval = fc.showSaveDialog((Component)((Object)InstanceExplorer.this));
                if (retval != 0) {
                    return;
                }
                Instances dataset = null;
                for (int i = 0; i < InstanceExplorer.this.getContainerManager().count(); ++i) {
                    InstanceContainer cont = (InstanceContainer)InstanceExplorer.this.getContainerManager().get(i);
                    if (i == 0) {
                        dataset = new Instances(cont.getData().getDatasetHeader(), 0);
                    }
                    if (!cont.isVisible()) continue;
                    dataset.add((weka.core.Instance)cont.getData().toInstance().copy());
                }
                if (dataset == null) {
                    return;
                }
                AbstractFileSaver saver = fc.getSaver();
                saver.setInstances(dataset);
                try {
                    saver.writeBatch();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    GUIHelper.showErrorMessage((Component)((Object)InstanceExplorer.this), (String)("Error saving instances:\n" + ex));
                }
            }
        });
        menu.add(item);
    }

    public JPopupMenu getContainerListPopupMenu(ContainerTable<InstanceContainerManager, InstanceContainer> table, int row) {
        JPopupMenu result = new JPopupMenu();
        final ContainerTable<InstanceContainerManager, InstanceContainer> tableF = table;
        final int rowF = row;
        JMenuItem item = new JMenuItem("Toggle visibility");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = tableF.getSelectedRows();
                if (indices.length == 0) {
                    indices = new int[]{rowF};
                }
                for (int i = 0; i < indices.length; ++i) {
                    InstanceContainer cont;
                    cont.setVisible(!(cont = (InstanceContainer)InstanceExplorer.this.getContainerManager().get(indices[i])).isVisible());
                }
            }
        });
        result.add(item);
        item = new JMenuItem("Choose color...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = JColorChooser.showDialog((Component)tableF, "Choose color for " + ((InstanceContainer)InstanceExplorer.this.getContainerManager().get(rowF)).getData().getID(), ((InstanceContainer)InstanceExplorer.this.getContainerManager().get(rowF)).getColor());
                if (c != null) {
                    ((InstanceContainer)InstanceExplorer.this.getContainerManager().get(rowF)).setColor(c);
                }
            }
        });
        result.add(item);
        result.addSeparator();
        item = new JMenuItem("Remove");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = tableF.getSelectedRows();
                if (indices.length == 0) {
                    indices = new int[]{rowF};
                }
                InstanceExplorer.this.getContainerManager().startUpdate();
                for (int i = indices.length - 1; i >= 0; --i) {
                    InstanceExplorer.this.getContainerManager().remove(indices[i]);
                }
                InstanceExplorer.this.getContainerManager().finishUpdate();
            }
        });
        result.add(item);
        item = new JMenuItem("Remove all");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstanceExplorer.this.getContainerManager().clear();
            }
        });
        result.add(item);
        result.addSeparator();
        item = new JMenuItem("Notes");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = tableF.getSelectedRows();
                if (indices.length == 0) {
                    indices = new int[]{rowF};
                }
                Vector<InstanceContainer> data = new Vector<InstanceContainer>();
                for (int i = 0; i < indices.length; ++i) {
                    data.add((InstanceContainer)InstanceExplorer.this.getContainerManager().get(indices[i]));
                }
                InstanceExplorer.this.showNotes(data);
            }
        });
        result.add(item);
        return result;
    }

    protected void showNotes(Vector<InstanceContainer> data) {
        NotesFactory.Dialog dialog = this.getParentDialog() != null ? NotesFactory.getDialog((Dialog)this.getParentDialog(), (Dialog.ModalityType)Dialog.ModalityType.MODELESS) : NotesFactory.getDialog((Frame)this.getParentFrame(), (boolean)false);
        dialog.setData(data);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
    }

    protected void showStatistics(Vector<InformativeStatistic> stats) {
        InformativeStatisticFactory.Dialog dialog = this.getParentDialog() != null ? InformativeStatisticFactory.getDialog((Dialog)this.getParentDialog(), (Dialog.ModalityType)Dialog.ModalityType.MODELESS) : InformativeStatisticFactory.getDialog((Frame)this.getParentFrame(), (boolean)false);
        dialog.setStatistics(stats);
        dialog.setVisible(true);
    }

    protected void showHistogram(Vector<InstanceContainer> data) {
        if (this.m_HistogramSetup == null) {
            this.m_HistogramSetup = this.getParentDialog() != null ? HistogramFactory.getSetupDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : HistogramFactory.getSetupDialog(this.getParentFrame(), true);
        }
        this.m_HistogramSetup.setLocationRelativeTo((Component)((Object)this));
        this.m_HistogramSetup.setVisible(true);
        if (this.m_HistogramSetup.getResult() != 0) {
            return;
        }
        HistogramFactory.Dialog dialog = this.getParentDialog() != null ? HistogramFactory.getDialog(this.getParentDialog(), Dialog.ModalityType.MODELESS) : HistogramFactory.getDialog(this.getParentFrame(), false);
        for (int i = 0; i < data.size(); ++i) {
            Instance inst = data.get(i).getData();
            dialog.add((ArrayHistogram)this.m_HistogramSetup.getCurrent(), inst, "" + inst.getID());
        }
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
    }

    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JComponent.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return this.getContainerManager().countVisible() > 0;
    }

    public Object getSendToItem(Class[] cls) {
        Object result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, (Class[])cls)) {
            if (this.getContainerManager().countVisible() > 0) {
                result = SendToActionUtils.nextTmpFile((String)"instanceexplorer", (String)"arff");
                Instances inst = this.m_PanelInstance.getInstances();
                try {
                    ConverterUtils.DataSink.write((String)result.getAbsolutePath(), (Instances)inst);
                }
                catch (Exception e) {
                    result = null;
                    GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write instances to '" + result + "'!"));
                }
            }
        } else if (SendToActionUtils.isAvailable(JComponent.class, (Class[])cls) && this.getContainerManager().countVisible() > 0) {
            result = this;
        }
        return result;
    }

    public void cleanUp() {
        this.m_PanelInstance.cleanUp();
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("instance explorer");
        }
        return m_Properties;
    }
}

