/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;

public class SortOnAttribute
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = 4444860420131316510L;
    protected SingleIndex m_AttributeIndex = new SingleIndex("first");

    public String globalInfo() {
        return "Sorts the instances on a particular attribute.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe index of the attribute to sort on.\n\t(default: first).", "C", 1, "-C <col>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"C", (String[])options);
        if (tmpStr.length() > 0) {
            this.setAttributeIndex(tmpStr);
        } else {
            this.setAttributeIndex("first");
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-C");
        result.add(this.getAttributeIndex());
        return result.toArray(new String[result.size()]);
    }

    public void setAttributeIndex(String value) {
        this.m_AttributeIndex.setSingleIndex(value);
        this.reset();
    }

    public String getAttributeIndex() {
        return this.m_AttributeIndex.getSingleIndex();
    }

    public String attributeIndexTipText() {
        return "The 1-based index of the attribute to sort on; 'first' and 'last' are accepted as well.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    protected Instances process(Instances instances) throws Exception {
        this.m_AttributeIndex.setUpper(instances.numAttributes() - 1);
        Instances result = new Instances(instances);
        result.sort(this.m_AttributeIndex.getIndex());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 6671 $");
    }

    public static void main(String[] args) {
        SortOnAttribute.runFilter((Filter)new SortOnAttribute(), (String[])args);
    }
}

