/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize.plugins;

import adams.core.Utils;
import adams.data.container.DataPoint;
import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequencePointComparator;
import adams.gui.core.BaseDialog;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequenceLinePaintlet;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import adams.gui.visualization.sequence.XYSequencePaintletWithFixedXYRange;
import adams.gui.visualization.sequence.XYSequencePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instances;
import weka.gui.visualize.plugins.VisualizePlugin;

public class ThresholdCurves
implements VisualizePlugin {
    public JMenuItem getVisualizeMenuItem(final FastVector preds, final Attribute classAtt) {
        if (!classAtt.isNominal()) {
            return null;
        }
        JMenuItem result = new JMenuItem("Threshold curves");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYSequencePanel panel = new XYSequencePanel();
                panel.getSidePanel().setPreferredSize(new Dimension(200, 0));
                panel.getPlot().getAxis(Axis.LEFT).setTopMargin(0.0);
                panel.getPlot().getAxis(Axis.LEFT).setBottomMargin(0.0);
                panel.getPlot().getAxis(Axis.LEFT).setNumberFormat("0.00");
                panel.getPlot().getAxis(Axis.BOTTOM).setTopMargin(0.0);
                panel.getPlot().getAxis(Axis.BOTTOM).setBottomMargin(0.0);
                panel.getPlot().getAxis(Axis.BOTTOM).setNumberFormat("0.00");
                XYSequenceLinePaintlet basePaintlet = new XYSequenceLinePaintlet();
                basePaintlet.setPaintAll(true);
                XYSequencePaintletWithFixedXYRange paintlet = new XYSequencePaintletWithFixedXYRange();
                paintlet.setMinX(0.0);
                paintlet.setMaxX(1.0);
                paintlet.setMinY(0.0);
                paintlet.setMaxY(1.0);
                paintlet.setPaintlet((XYSequencePaintlet)basePaintlet);
                panel.setPaintlet((XYSequencePaintlet)paintlet);
                XYSequenceContainerManager manager = (XYSequenceContainerManager)panel.getContainerManager();
                for (int i = 0; i < classAtt.numValues(); ++i) {
                    ThresholdCurve tc = new ThresholdCurve();
                    Instances result = tc.getCurve(preds, i);
                    XYSequence seq = new XYSequence();
                    seq.setID(classAtt.value(i) + " (AUC: " + Utils.doubleToString((double)ThresholdCurve.getROCArea((Instances)result), (int)4) + ")");
                    seq.setComparison(XYSequencePointComparator.Comparison.X_AND_Y);
                    for (int n = 0; n < result.numInstances(); ++n) {
                        double x = result.instance(n).value(result.attribute("False Positive Rate"));
                        double y = result.instance(n).value(result.attribute("True Positive Rate"));
                        XYSequencePoint point = new XYSequencePoint(x, y);
                        seq.add((DataPoint)point);
                    }
                    XYSequenceContainer cont = manager.newContainer((Comparable)seq);
                    manager.add(cont);
                }
                BaseDialog dialog = new BaseDialog();
                dialog.setTitle("Threshold curves (" + classAtt.name() + ")");
                dialog.getContentPane().setLayout(new BorderLayout());
                dialog.getContentPane().add((Component)panel, "Center");
                dialog.setSize(800, 600);
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            }
        });
        return result;
    }

    public String getMinVersion() {
        return "3.7.4";
    }

    public String getMaxVersion() {
        return "3.8.0";
    }

    public String getDesignVersion() {
        return "3.7.4";
    }
}

