/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.VariableName;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.condition.test.FileExists;
import adams.flow.condition.test.TestCondition;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.Variable;
import adams.flow.standalone.ConditionalStandalone;
import adams.flow.standalone.SetVariable;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ConditionalStandaloneTest
extends AbstractFlowTest {
    public ConditionalStandaloneTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        FileExists fe = new FileExists();
        fe.setFile((PlaceholderFile)new TmpFile("vote.arff"));
        SetVariable sv = new SetVariable();
        sv.setVariableName(new VariableName("file_exists"));
        sv.setVariableValue("yes");
        ConditionalStandalone cond = new ConditionalStandalone();
        cond.setCondition((TestCondition)fe);
        cond.setActor((AbstractActor)sv);
        Variable var = new Variable();
        var.setVariableName(new VariableName("file_exists"));
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{cond, var, df});
        flow.getVariables().set("file_exists", "no");
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(ConditionalStandaloneTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ConditionalStandaloneTest.runTest((Test)ConditionalStandaloneTest.suite());
    }
}

