/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.CallableActorReference;
import adams.flow.core.EvaluationStatistic;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.flow.source.WekaClassifierSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaCrossValidationEvaluator;
import adams.flow.transformer.WekaEvaluationValues;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;

public class WekaEvaluationValuesTest
extends AbstractFlowTest {
    public WekaEvaluationValuesTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.copyResourceToTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        WekaClassifierSetup cls = new WekaClassifierSetup();
        cls.setName("cls");
        cls.setClassifier((Classifier)new J48());
        CallableActors ga = new CallableActors();
        ga.setActors(new AbstractActor[]{cls});
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("${TMP}/vote.arff"), new BaseString("${TMP}/labor.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.DATASET);
        WekaClassSelector cs = new WekaClassSelector();
        WekaCrossValidationEvaluator cv = new WekaCrossValidationEvaluator();
        cv.setClassifier(new CallableActorReference("cls"));
        WekaEvaluationValues eval = new WekaEvaluationValues();
        eval.setStatisticValues(new EvaluationStatistic[]{EvaluationStatistic.AREA_UNDER_ROC, EvaluationStatistic.PERCENT_CORRECT, EvaluationStatistic.FALSE_POSITIVE_RATE});
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sc, fr, cs, cv, eval, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(WekaEvaluationValuesTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaEvaluationValuesTest.runTest((Test)WekaEvaluationValuesTest.suite());
    }
}

