/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaSubsets;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ArffLoader;

public class WekaSubsetsTest
extends AbstractFlowTest {
    public WekaSubsetsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(WekaSubsetsTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp1 = new AbstractActor[4];
            FileSupplier tmp2 = new FileSupplier();
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("files");
            tmp2.setFiles(new PlaceholderFile[]{new TmpFile("labor.arff")});
            tmp1[0] = tmp2;
            WekaFileReader tmp4 = new WekaFileReader();
            argOption = (AbstractArgumentOption)tmp4.getOptionManager().findByProperty("customLoader");
            ArffLoader tmp6 = new ArffLoader();
            tmp4.setCustomLoader((AbstractFileLoader)tmp6);
            tmp1[1] = tmp4;
            WekaSubsets tmp7 = new WekaSubsets();
            argOption = (AbstractArgumentOption)tmp7.getOptionManager().findByProperty("index");
            tmp7.setIndex(new Index("last"));
            tmp1[2] = tmp7;
            DumpFile tmp9 = new DumpFile();
            argOption = (AbstractArgumentOption)tmp9.getOptionManager().findByProperty("outputFile");
            tmp9.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
            tmp9.setAppend(true);
            tmp1[3] = tmp9;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            WekaSubsetsTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaSubsetsTest.runTest((Test)WekaSubsetsTest.suite());
    }
}

