/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractAdamsFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.AndrewsCurves;
import weka.test.AdamsTestHelper;

public class AndrewsCurvesTest
extends AbstractAdamsFilterTest {
    public AndrewsCurvesTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances = this.getFilteredClassifierData();
    }

    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances testinst = new TestInstances();
        testinst.setNumNominal(0);
        testinst.setNumNumeric(20);
        testinst.setClassType(1);
        testinst.setNumInstances(50);
        return testinst.generate();
    }

    public Filter getFilter() {
        return new AndrewsCurves();
    }

    public Filter getFilter(int num) {
        AndrewsCurves result = new AndrewsCurves();
        result.setNumPoints(num);
        return result;
    }

    protected void performTest() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AndrewsCurvesTest.fail((String)("Exception thrown on setInputFormat(): \n" + ex.getMessage()));
        }
        try {
            result = Filter.useFilter((Instances)icopy, (Filter)this.m_Filter);
            AndrewsCurvesTest.assertNotNull((Object)result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AndrewsCurvesTest.fail((String)("Exception thrown on useFilter(): \n" + ex.getMessage()));
        }
        AndrewsCurves filter = (AndrewsCurves)this.m_Filter;
        int numAtts = filter.getNumPoints() + (icopy.classIndex() > -1 ? 1 : 0);
        AndrewsCurvesTest.assertEquals((int)numAtts, (int)result.numAttributes());
        AndrewsCurvesTest.assertEquals((int)icopy.numInstances(), (int)this.m_Instances.numInstances());
    }

    public void testDefault() {
        this.m_Filter = this.getFilter();
        this.testBuffered();
        this.performTest();
    }

    public void testSmall() {
        this.m_Filter = this.getFilter(10);
        this.testBuffered();
        this.performTest();
    }

    public void testNoRight() {
        this.m_Filter = this.getFilter(1000);
        this.testBuffered();
        this.performTest();
    }

    public static Test suite() {
        return new TestSuite(AndrewsCurvesTest.class);
    }

    public static void main(String[] args) {
        AdamsTestHelper.setRegressionRoot();
        TestRunner.run((Test)AndrewsCurvesTest.suite());
    }
}

