/*
 * Decompiled with CFR 0.152.
 */
package adams.data.weka.columnfinder;

import adams.data.weka.columnfinder.AbstractTrainableColumnFinder;
import adams.data.weka.columnfinder.ColumnFinder;
import adams.data.weka.columnfinder.TrainableColumnFinder;
import java.util.Arrays;
import java.util.HashSet;
import weka.core.Instances;

public class MultiColumnFinder
extends AbstractTrainableColumnFinder {
    private static final long serialVersionUID = 1441664440186470414L;
    protected ColumnFinder[] m_Finders;
    protected Combination m_Combination;

    public String globalInfo() {
        return "Applies multiple column finding algorithms to the data.\nThe indices can be either joined or intersected.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finders", (Object)new ColumnFinder[0]);
        this.m_OptionManager.add("combination", "combination", (Object)Combination.JOIN);
    }

    public void setFinders(ColumnFinder[] value) {
        this.m_Finders = value;
        this.reset();
    }

    public ColumnFinder[] getFinders() {
        return this.m_Finders;
    }

    public String findersTipText() {
        return "The column finders to use.";
    }

    public void setCombination(Combination value) {
        this.m_Combination = value;
        this.reset();
    }

    public Combination getCombination() {
        return this.m_Combination;
    }

    public String combinationTipText() {
        return "Defines how the indices are combined.";
    }

    @Override
    protected boolean doTrainColumnFinder(Instances data) {
        boolean result = true;
        for (int i = 0; i < this.m_Finders.length && (!(this.m_Finders[i] instanceof TrainableColumnFinder) || (result = ((TrainableColumnFinder)this.m_Finders[i]).trainColumnFinder(data))); ++i) {
        }
        return result;
    }

    @Override
    protected int[] doFindColumns(Instances data) {
        int i;
        HashSet<Integer> all = new HashSet<Integer>();
        block4: for (i = 0; i < this.m_Finders.length; ++i) {
            int[] indicesArray = this.m_Finders[i].findColumns(data);
            if (i == 0) {
                all.addAll(MultiColumnFinder.arrayToHashSet(indicesArray));
                continue;
            }
            switch (this.m_Combination) {
                case JOIN: {
                    all.addAll(MultiColumnFinder.arrayToHashSet(indicesArray));
                    continue block4;
                }
                case INTERSECT: {
                    HashSet<Integer> indices = MultiColumnFinder.arrayToHashSet(indicesArray);
                    all.retainAll(indices);
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unhandled combination: " + (Object)((Object)this.m_Combination));
                }
            }
        }
        int[] result = new int[all.size()];
        if (result.length > 0) {
            i = 0;
            for (Integer index : all) {
                result[i] = index;
                ++i;
            }
            Arrays.sort(result);
        }
        return result;
    }

    public static enum Combination {
        JOIN,
        INTERSECT;

    }
}

