/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.Prediction;

public class WekaAccumulatedError
extends AbstractTransformer {
    private static final long serialVersionUID = 43672155926689520L;
    public static final String BACKUP_PREDICTIONS = "predictions";
    public static final String BACKUP_NUMPREDICTIONS = "num predictions";
    public static final String BACKUP_ACCUMULATEDERROR = "accumulated error";
    protected String m_PlotName;
    protected List<SortablePrediction> m_Predictions;
    protected int m_NumPredictions;
    protected double m_AccumulatdError;

    public String globalInfo() {
        return "Generates plot containers from an evaluation object's predictions. The predictions are first sorted according to their error, smallest to largest, and then plot containers are created with the RMSE being accumulated.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("plot-name", "plotName", (Object)"Plot");
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"plotName", (Object)this.m_PlotName);
    }

    public void setPlotName(String value) {
        this.m_PlotName = value;
        this.reset();
    }

    public String getPlotName() {
        return this.m_PlotName;
    }

    public String plotNameTipText() {
        return "The name for the plot.";
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, WekaEvaluationContainer.class};
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_PREDICTIONS);
        this.pruneBackup(BACKUP_NUMPREDICTIONS);
        this.pruneBackup(BACKUP_ACCUMULATEDERROR);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        result.put(BACKUP_PREDICTIONS, this.m_Predictions);
        result.put(BACKUP_NUMPREDICTIONS, this.m_NumPredictions);
        result.put(BACKUP_ACCUMULATEDERROR, this.m_AccumulatdError);
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_PREDICTIONS)) {
            this.m_Predictions = (List)state.get(BACKUP_PREDICTIONS);
            state.remove(BACKUP_PREDICTIONS);
        }
        if (state.containsKey(BACKUP_NUMPREDICTIONS)) {
            this.m_NumPredictions = (Integer)state.get(BACKUP_NUMPREDICTIONS);
            state.remove(BACKUP_NUMPREDICTIONS);
        }
        if (state.containsKey(BACKUP_ACCUMULATEDERROR)) {
            this.m_AccumulatdError = (Double)state.get(BACKUP_ACCUMULATEDERROR);
            state.remove(BACKUP_ACCUMULATEDERROR);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_Predictions = new ArrayList<SortablePrediction>();
        this.m_NumPredictions = 0;
        this.m_AccumulatdError = 0.0;
    }

    protected String doExecute() {
        String result = null;
        Evaluation eval = this.m_InputToken.getPayload() instanceof WekaEvaluationContainer ? (Evaluation)((WekaEvaluationContainer)((Object)this.m_InputToken.getPayload())).getValue("Evaluation") : (Evaluation)this.m_InputToken.getPayload();
        ArrayList predictions = eval.predictions();
        if (predictions != null) {
            this.m_NumPredictions = predictions.size();
            for (int i = 0; i < predictions.size(); ++i) {
                this.m_Predictions.add(new SortablePrediction((Prediction)predictions.get(i)));
            }
            Collections.sort(this.m_Predictions);
        } else {
            this.getLogger().severe("No predictions available from Evaluation object!");
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{SequencePlotterContainer.class};
    }

    public boolean hasPendingOutput() {
        return this.m_Predictions.size() > 0;
    }

    public Token output() {
        Prediction pred = this.m_Predictions.get(0).getPrediction();
        double error = Math.sqrt(Math.pow(pred.actual() - pred.predicted(), 2.0)) / Math.sqrt(this.m_NumPredictions);
        this.m_AccumulatdError += error;
        this.m_Predictions.remove(0);
        this.m_InputToken = null;
        Token result = new Token((Object)new SequencePlotterContainer(this.m_PlotName, (Comparable)Double.valueOf(this.m_NumPredictions - this.m_Predictions.size()), (Comparable)Double.valueOf(this.m_AccumulatdError)));
        return result;
    }

    public void wrapUp() {
        this.m_Predictions = null;
        this.m_AccumulatdError = 0.0;
        this.m_NumPredictions = 0;
        super.wrapUp();
    }

    public static class SortablePrediction
    implements Comparable {
        protected Prediction m_Prediction;

        public SortablePrediction(Prediction pred) {
            this.m_Prediction = pred;
        }

        public Prediction getPrediction() {
            return this.m_Prediction;
        }

        public double getAbsoluteDifference() {
            if (Double.isNaN(this.m_Prediction.actual()) || Double.isNaN(this.m_Prediction.predicted())) {
                return Double.NaN;
            }
            return Math.abs(this.m_Prediction.actual() - this.m_Prediction.predicted()) * this.m_Prediction.weight();
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 1;
            }
            if (!(o instanceof SortablePrediction)) {
                return -1;
            }
            SortablePrediction other = (SortablePrediction)o;
            if (Double.isNaN(this.getAbsoluteDifference()) && Double.isNaN(other.getAbsoluteDifference())) {
                return 0;
            }
            if (Double.isNaN(this.getAbsoluteDifference())) {
                return 1;
            }
            if (Double.isNaN(other.getAbsoluteDifference())) {
                return -1;
            }
            return Double.compare(this.getAbsoluteDifference(), other.getAbsoluteDifference());
        }

        public String toString() {
            return "actual=" + this.m_Prediction.actual() + ", predicted=" + this.m_Prediction.predicted() + ", weight=" + this.m_Prediction.weight();
        }
    }
}

