/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import weka.core.Instances;
import weka.core.converters.TextDirectoryLoader;

public class WekaTextDirectoryReader
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 9097157984356638281L;
    protected boolean m_StoreFilename;
    protected String m_CharSet;

    public String globalInfo() {
        return new TextDirectoryLoader().globalInfo() + "\n" + "Uses the WEKA " + TextDirectoryLoader.class.getName() + " converter.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("store-filename", "storeFilename", (Object)false);
        this.m_OptionManager.add("char-set", "charSet", (Object)"UTF-8");
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"charSet", (Object)this.m_CharSet);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"storeFilename", (boolean)this.m_StoreFilename, (String)"(add filename)", (String)", ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{Instances.class};
    }

    public void setStoreFilename(boolean value) {
        this.m_StoreFilename = value;
        this.reset();
    }

    public boolean getStoreFilename() {
        return this.m_StoreFilename;
    }

    public String storeFilenameTipText() {
        return "If enabled, the filename will be stored in extra attribute.";
    }

    public void setCharSet(String value) {
        this.m_CharSet = value;
        this.reset();
    }

    public String getCharSet() {
        return this.m_CharSet;
    }

    public String charSetTipText() {
        return "The character set to use when loading the text files.";
    }

    protected String doExecute() {
        String result = null;
        try {
            File file = this.m_InputToken.getPayload() instanceof File ? (File)this.m_InputToken.getPayload() : new PlaceholderFile((String)this.m_InputToken.getPayload());
            if (file.isDirectory()) {
                TextDirectoryLoader loader = new TextDirectoryLoader();
                loader.setDirectory(file);
                loader.setOutputFilename(this.m_StoreFilename);
                loader.setCharSet(this.m_CharSet);
                Instances data = loader.getDataSet();
                this.m_OutputToken = new Token((Object)data);
                this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
            } else {
                result = "Input is not a directory: " + file;
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to load directory with text files: ", e);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }
}

