/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.wekaclusterer;

import adams.data.statistics.StatUtils;
import adams.flow.transformer.wekaclusterer.AbstractClusterMembershipPostProcessor;
import java.util.Hashtable;
import weka.clusterers.Clusterer;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;

public class ClusterCenters
extends AbstractClusterMembershipPostProcessor {
    private static final long serialVersionUID = 5983792992620091051L;

    public String globalInfo() {
        return "Computes the cluster centers for the provided dataset. An additional attribute is added to the dataset structure that contains the cluster index.\nOnly numeric attributes are considered when computing the centers.\nStored in container under: Clustered dataset";
    }

    protected Instances createOutputFormat(Instances data) {
        Instances result = new Instances(data, 0);
        try {
            Add add = new Add();
            add.setAttributeIndex("1");
            add.setAttributeName("Cluster index");
            add.setAttributeType(new SelectedTag(0, Add.TAGS_TYPE));
            add.setInputFormat(result);
            result = Filter.useFilter((Instances)result, (Filter)add);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    protected Instances calculateCenters(Instances data, Clusterer clusterer, Instances outputFormat) {
        int i;
        Instances result = new Instances(outputFormat, 0);
        Hashtable<Integer, Instances> clusters = new Hashtable<Integer, Instances>();
        boolean error = false;
        String errorMsg = null;
        for (i = 0; i < data.numInstances(); ++i) {
            try {
                int cluster = clusterer.clusterInstance(data.instance(i));
                if (!clusters.containsKey(cluster)) {
                    clusters.put(cluster, new Instances(data, 0));
                }
                ((Instances)clusters.get(cluster)).add(data.instance(i));
                continue;
            }
            catch (Exception e) {
                if (error) continue;
                error = true;
                errorMsg = e.toString();
            }
        }
        if (!error) {
            for (Integer cl : clusters.keySet()) {
                Instances subset = (Instances)clusters.get(cl);
                DenseInstance inst = new DenseInstance(result.numAttributes());
                inst.setValue(0, (double)cl.intValue());
                for (i = 0; i < subset.numAttributes(); ++i) {
                    if (!subset.attribute(i).isNumeric()) continue;
                    double[] values = subset.attributeToDoubleArray(i);
                    inst.setValue(i + 1, StatUtils.mean((double[])values));
                }
                result.add((Instance)inst);
            }
            result.sort(0);
        } else {
            this.getLogger().severe("At least one error occurred: " + errorMsg);
        }
        return result;
    }

    @Override
    protected Instances processDatasetWithClusterer(Instances data, Clusterer clusterer) {
        Instances result = this.createOutputFormat(data);
        result = this.calculateCenters(data, clusterer, result);
        return result;
    }
}

