/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.container.WekaModelContainer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import weka.core.Drawable;
import weka.gui.graphvisualizer.GraphVisualizer;

public class WekaGraphVisualizer
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 1970232977500522747L;

    public String globalInfo() {
        return "Displays BayesNet graphs in XML or BIF notation\nEither displays the contents of a file or an object that implements " + Drawable.class.getName() + " and generates a BayesNet graph.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class, Drawable.class, WekaModelContainer.class};
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel();
        result.setLayout((LayoutManager)new BorderLayout());
        return result;
    }

    public void clearPanel() {
        this.m_Panel.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GraphVisualizer createGraphVisualizer(Token token) {
        GraphVisualizer result = null;
        Reader reader = null;
        InputStream stream = null;
        try {
            Object input = token.getPayload();
            if (input instanceof WekaModelContainer) {
                input = ((WekaModelContainer)((Object)input)).getValue("Model");
            }
            String filename = null;
            String graph = null;
            if (input instanceof String) {
                filename = (String)input;
            } else if (input instanceof File) {
                filename = ((File)input).getAbsolutePath();
            } else {
                if (((Drawable)input).graphType() != 2) {
                    throw new IllegalArgumentException(token.getPayload().getClass().getName() + " does not generate a BayesNet graph!");
                }
                graph = ((Drawable)input).graph();
            }
            result = new GraphVisualizer();
            if (filename != null) {
                if (filename.toLowerCase().endsWith(".xml") || filename.toLowerCase().endsWith(".bif")) {
                    stream = new FileInputStream(filename);
                    result.readBIF(stream);
                } else {
                    reader = new FileReader(filename);
                    result.readDOT(reader);
                }
            } else if (graph != null) {
                result.readBIF(graph);
            }
        }
        catch (Exception e) {
            this.handleException("Failed to read input!", e);
            GraphVisualizer graphVisualizer = result;
            return graphVisualizer;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    protected void display(Token token) {
        this.clearPanel();
        GraphVisualizer visualizer = this.createGraphVisualizer(token);
        if (visualizer != null) {
            this.m_Panel.add((Component)visualizer, (Object)"Center");
            visualizer.layoutGraph();
        }
    }

    public JComponent supplyComponent() {
        JScrollPane pane = (JScrollPane)GUIHelper.findFirstComponent((Container)this.m_Panel, JScrollPane.class, (boolean)true, (boolean)true);
        if (pane != null) {
            return (JComponent)pane.getViewport().getView();
        }
        return null;
    }

    public DisplayPanel createDisplayPanel(Token token) {
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = 7384093089760722339L;
            protected GraphVisualizer m_Visualizer;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
            }

            public void display(Token token) {
                this.m_Visualizer = WekaGraphVisualizer.this.createGraphVisualizer(token);
                this.add((Component)this.m_Visualizer, "Center");
                this.m_Visualizer.layoutGraph();
            }

            public void cleanUp() {
            }

            public void clearPanel() {
                this.removeAll();
            }

            public JComponent supplyComponent() {
                JScrollPane pane = (JScrollPane)GUIHelper.findFirstComponent((Container)this.m_Visualizer, JScrollPane.class, (boolean)true, (boolean)true);
                if (pane != null) {
                    return (JComponent)pane.getViewport().getView();
                }
                return null;
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

