/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.conversion.Conversion;
import adams.data.conversion.WekaInstanceToAdamsInstance;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.Counting;
import adams.flow.control.ConditionalTee;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.Convert;
import adams.flow.transformer.GetReportValue;
import adams.flow.transformer.SetReportValue;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SetReportValueTest
extends AbstractFlowTest {
    public SetReportValueTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("bolts.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.INCREMENTAL);
        WekaClassSelector cs = new WekaClassSelector();
        Convert ci = new Convert();
        ci.setConversion((Conversion)new WekaInstanceToAdamsInstance());
        SetReportValue srv = new SetReportValue();
        srv.setField(new Field("Class", DataType.NUMERIC));
        srv.setValue("100.0");
        GetReportValue grv = new GetReportValue();
        grv.setField(new Field("Class", DataType.NUMERIC));
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Sequence seq = new Sequence();
        seq.setActors(new AbstractActor[]{ci, srv, grv, df});
        ConditionalTee ct = new ConditionalTee();
        Counting count = new Counting();
        count.setMaximum(5);
        count.setInterval(1);
        ct.setCondition((BooleanCondition)count);
        ct.add(0, (AbstractActor)seq);
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, fr, cs, ct});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(SetReportValueTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SetReportValueTest.runTest((Test)SetReportValueTest.suite());
    }
}

