/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseRegExp;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.WekaChooseAttributes;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ArffLoader;

public class WekaChooseAttributesTest
extends AbstractFlowTest {
    public WekaChooseAttributesTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(WekaChooseAttributesTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp1 = new AbstractActor[5];
            FileSupplier tmp2 = new FileSupplier();
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("files");
            tmp2.setFiles(new PlaceholderFile[]{(PlaceholderFile)argOption.valueOf("${TMP}/bolts.arff")});
            tmp1[0] = tmp2;
            WekaFileReader tmp4 = new WekaFileReader();
            argOption = (AbstractArgumentOption)tmp4.getOptionManager().findByProperty("customLoader");
            ArffLoader tmp6 = new ArffLoader();
            tmp4.setCustomLoader((AbstractFileLoader)tmp6);
            tmp1[1] = tmp4;
            WekaClassSelector tmp7 = new WekaClassSelector();
            tmp1[2] = tmp7;
            WekaChooseAttributes tmp8 = new WekaChooseAttributes();
            tmp8.setStopFlowIfCanceled(true);
            argOption = (AbstractArgumentOption)tmp8.getOptionManager().findByProperty("customStopMessage");
            tmp8.setCustomStopMessage((String)argOption.valueOf("User canceled selection of attributes!"));
            argOption = (AbstractArgumentOption)tmp8.getOptionManager().findByProperty("preSelection");
            tmp8.setPreSelection((BaseRegExp)argOption.valueOf("SPEED.*"));
            tmp8.setNonInteractive(true);
            tmp1[3] = tmp8;
            DumpFile tmp11 = new DumpFile();
            argOption = (AbstractArgumentOption)tmp11.getOptionManager().findByProperty("outputFile");
            tmp11.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            tmp1[4] = tmp11;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            WekaChooseAttributesTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaChooseAttributesTest.runTest((Test)WekaChooseAttributesTest.suite());
    }
}

