/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaGetInstanceValue;
import adams.flow.transformer.WekaSetInstanceValue;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class WekaSetInstanceValueTest
extends AbstractFlowTest {
    public WekaSetInstanceValueTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile1.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile2.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("labor.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile1.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile2.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("labor.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.INCREMENTAL);
        WekaClassSelector cs = new WekaClassSelector();
        WekaSetInstanceValue set1 = new WekaSetInstanceValue();
        set1.setIndex(new Index("last"));
        set1.setValue("bad");
        WekaGetInstanceValue get1 = new WekaGetInstanceValue();
        get1.setIndex(new Index("last"));
        DumpFile df1 = new DumpFile();
        df1.setAppend(true);
        df1.setOutputFile((PlaceholderFile)new TmpFile("dumpfile1.txt"));
        Sequence seq1 = new Sequence();
        seq1.setActors(new AbstractActor[]{set1, get1, df1});
        WekaSetInstanceValue set2 = new WekaSetInstanceValue();
        set2.setIndex(new Index("first"));
        set2.setValue("42.0");
        WekaGetInstanceValue get2 = new WekaGetInstanceValue();
        get2.setIndex(new Index("first"));
        DumpFile df2 = new DumpFile();
        df2.setAppend(true);
        df2.setOutputFile((PlaceholderFile)new TmpFile("dumpfile2.txt"));
        Sequence seq2 = new Sequence();
        seq2.setActors(new AbstractActor[]{set2, get2, df2});
        Branch br = new Branch();
        br.setBranches(new AbstractActor[]{seq1, seq2});
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, fr, cs, br});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile1.txt"), new TmpFile("dumpfile2.txt")});
    }

    public static Test suite() {
        return new TestSuite(WekaSetInstanceValueTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaSetInstanceValueTest.runTest((Test)WekaSetInstanceValueTest.suite());
    }
}

