/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment.ext;

import adams.core.DateUtils;
import adams.core.SerializedObject;
import java.io.Serializable;
import java.util.Date;
import weka.experiment.Experiment;
import weka.gui.experiment.ext.ExperimenterPanel;

public abstract class AbstractExperimentRunner
extends Thread
implements Serializable {
    private static final long serialVersionUID = -5591889874714150118L;
    protected static final String NOT_RUNNING = "Not running";
    protected ExperimenterPanel m_Owner;
    protected Experiment m_Exp;
    protected boolean m_Running;

    public AbstractExperimentRunner(ExperimenterPanel owner) throws Exception {
        this.m_Owner = owner;
        Experiment exp = this.m_Owner.getExperiment();
        this.logMessage("--> START: " + DateUtils.getTimestampFormatter().format(new Date()));
        this.logMessage("Running experiment: " + exp.toString());
        this.logMessage("Writing experiment copy");
        SerializedObject so = new SerializedObject((Serializable)exp);
        this.logMessage("Reading experiment copy");
        this.m_Exp = (Experiment)so.getObject();
        this.logMessage("Made experiment copy");
    }

    public void abortExperiment() {
        this.m_Running = false;
    }

    public boolean isRunning() {
        return this.m_Running;
    }

    public void logMessage(Throwable t) {
        this.m_Owner.logMessage(t);
    }

    public void logMessage(String msg) {
        this.m_Owner.logMessage(msg);
    }

    public void logError(Throwable t, String title) {
        this.m_Owner.logError(t, title);
    }

    public void logError(String msg, String title) {
        this.m_Owner.logError(msg, title);
    }

    public void showStatus(String msg) {
        this.m_Owner.showStatus(msg);
        this.m_Owner.logMessage(msg);
    }

    public void update() {
        this.m_Owner.update();
    }

    protected void preRun() throws Exception {
    }

    protected void doInitialize() throws Exception {
        this.m_Exp.initialize();
    }

    protected abstract void doRun() throws Exception;

    protected void postRun() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_Running = true;
        this.update();
        try {
            this.logMessage("Started");
            this.preRun();
            this.showStatus("Initializing...");
            this.doInitialize();
            this.showStatus("Running...");
            this.doRun();
        }
        catch (Exception ex) {
            this.logError(ex, "Execution error");
            this.showStatus(ex.getMessage());
        }
        finally {
            this.postRun();
        }
    }
}

