/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.logging.Level;
import javax.swing.JComponent;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.MarginCurve;
import weka.core.Instances;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class WekaMarginCurve
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 3247255046513744115L;
    protected VisualizePanel m_VisualizePanel;

    public String globalInfo() {
        return "Actor for displaying margin errors.";
    }

    protected int getDefaultWidth() {
        return 640;
    }

    protected int getDefaultHeight() {
        return 480;
    }

    public void clearPanel() {
        if (this.m_VisualizePanel != null) {
            this.m_VisualizePanel.removeAllPlots();
        }
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_VisualizePanel = new VisualizePanel();
        result.add((Component)this.m_VisualizePanel, (Object)"Center");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Evaluation.class, WekaEvaluationContainer.class};
    }

    protected void display(Token token) {
        try {
            Evaluation eval = token.getPayload() instanceof WekaEvaluationContainer ? (Evaluation)((WekaEvaluationContainer)((Object)token.getPayload())).getValue("Evaluation") : (Evaluation)token.getPayload();
            if (eval.predictions() == null) {
                this.getLogger().severe("No predictions available from Evaluation object!");
                return;
            }
            MarginCurve curve = new MarginCurve();
            Instances data = curve.getCurve(eval.predictions());
            PlotData2D plot = new PlotData2D(data);
            plot.m_displayAllPoints = true;
            boolean[] connectPoints = new boolean[data.numInstances()];
            for (int cp = 1; cp < connectPoints.length; ++cp) {
                connectPoints[cp] = true;
            }
            plot.setConnectPoints(connectPoints);
            this.m_VisualizePanel.addPlot(plot);
        }
        catch (Exception e) {
            this.handleException("Failed to display token: " + token, e);
        }
    }

    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_VisualizePanel != null) {
            this.m_VisualizePanel.removeAllPlots();
            this.m_VisualizePanel = null;
        }
    }

    protected Evaluation getEvaluation(Token token) {
        if (token.getPayload() instanceof WekaEvaluationContainer) {
            return (Evaluation)((WekaEvaluationContainer)((Object)token.getPayload())).getValue("Evaluation");
        }
        return (Evaluation)token.getPayload();
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        String name = token != null ? "Margin curve (" + this.getEvaluation(token).getHeader().relationName() + ")" : "Margin curve";
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(name){
            private static final long serialVersionUID = -3513994354297811163L;
            protected VisualizePanel m_VisualizePanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_VisualizePanel = new VisualizePanel();
                this.add((Component)this.m_VisualizePanel, "Center");
            }

            public void display(Token token) {
                try {
                    Evaluation eval = WekaMarginCurve.this.getEvaluation(token);
                    MarginCurve curve = new MarginCurve();
                    Instances data = curve.getCurve(eval.predictions());
                    PlotData2D plot = new PlotData2D(data);
                    plot.m_displayAllPoints = true;
                    boolean[] connectPoints = new boolean[data.numInstances()];
                    for (int cp = 1; cp < connectPoints.length; ++cp) {
                        connectPoints[cp] = true;
                    }
                    plot.setConnectPoints(connectPoints);
                    this.m_VisualizePanel.addPlot(plot);
                }
                catch (Exception e) {
                    WekaMarginCurve.this.getLogger().log(Level.SEVERE, "Failed to display token: " + token, e);
                }
            }

            public JComponent supplyComponent() {
                return this.m_VisualizePanel;
            }

            public void clearPanel() {
                this.m_VisualizePanel.removeAllPlots();
            }

            public void cleanUp() {
                this.m_VisualizePanel.removeAllPlots();
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return true;
    }
}

