/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import weka.core.Instance;

public class WekaGetInstanceValue
extends AbstractTransformer {
    private static final long serialVersionUID = -3057815118900209749L;
    protected Index m_Index;
    protected String m_AttributeName;

    public String globalInfo() {
        return "Retrieves a value from a WEKA Instance object.\nNotes:\n- date and relational values are forwarded as strings\n- missing values are output as '?' (without the single quotes)\n- the 'attribute name' option overrides the 'index' option";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", (Object)new Index("first"));
        this.m_OptionManager.add("attribute-name", "attributeName", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_Index = new Index("last");
    }

    public void setIndex(Index value) {
        this.m_Index = value;
        this.reset();
    }

    public Index getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The 1-based index of the attribute value to retrieve from the WEKA Instance.";
    }

    public void setAttributeName(String value) {
        this.m_AttributeName = value;
        this.reset();
    }

    public String getAttributeName() {
        return this.m_AttributeName;
    }

    public String attributeNameTipText() {
        return "The name of the attribute to get the value for.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"attributeName", (Object)(this.m_AttributeName.length() > 0 ? this.m_AttributeName : null));
        if (result != null) {
            return result;
        }
        return QuickInfoHelper.toString((OptionHandler)this, (String)"index", (Object)this.m_Index);
    }

    public Class[] accepts() {
        return new Class[]{Instance.class};
    }

    public Class[] generates() {
        return new Class[]{Double.class, String.class};
    }

    protected String doExecute() {
        String result = null;
        Instance inst = (Instance)this.m_InputToken.getPayload();
        try {
            int index;
            if (this.m_AttributeName.length() > 0) {
                index = inst.dataset().attribute(this.m_AttributeName).index();
            } else {
                this.m_Index.setMax(inst.numAttributes());
                index = this.m_Index.getIntIndex();
            }
            if (inst.isMissing(index)) {
                this.m_OutputToken = new Token((Object)"?");
            } else {
                switch (inst.attribute(index).type()) {
                    case 0: {
                        this.m_OutputToken = new Token((Object)inst.value(index));
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.m_OutputToken = new Token((Object)inst.stringValue(index));
                        break;
                    }
                    default: {
                        result = "Unhandled attribute type: " + inst.attribute(index).type();
                    }
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to obtain value from instance:\n" + inst, e);
        }
        return result;
    }
}

