/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.ContainerValuePicker;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaClustering;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class WekaClusteringTest
extends AbstractFlowTest {
    public WekaClusteringTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.copyResourceToTmp("simplekmeans.model");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("simplekmeans.model");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("vote.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.INCREMENTAL);
        WekaClassSelector cs = new WekaClassSelector();
        WekaClustering cls = new WekaClustering();
        cls.setModelFile((PlaceholderFile)new TmpFile("simplekmeans.model"));
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        ContainerValuePicker cvp = new ContainerValuePicker();
        cvp.setValueName("Cluster");
        cvp.add(0, (AbstractActor)df);
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, fr, cs, cls, cvp});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(WekaClusteringTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaClusteringTest.runTest((Test)WekaClusteringTest.suite());
    }
}

