/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.Counting;
import adams.flow.control.ConditionalTee;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaInstanceBuffer;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class WekaInstanceBufferTest
extends AbstractFlowTest {
    public WekaInstanceBufferTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("vote.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("vote.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.INCREMENTAL);
        WekaInstanceBuffer ib = new WekaInstanceBuffer();
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Sequence seq = new Sequence();
        seq.setActors(new AbstractActor[]{ib, df});
        ConditionalTee ct = new ConditionalTee();
        Counting count = new Counting();
        count.setMaximum(10);
        ct.setCondition((BooleanCondition)count);
        ct.add(0, (AbstractActor)seq);
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, fr, ct});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public void testInstancesToInstance() {
        Instances data = null;
        try {
            data = ConverterUtils.DataSource.read((String)new TmpFile("vote.arff").getAbsolutePath());
        }
        catch (Exception e) {
            WekaInstanceBufferTest.fail((String)"Failed to load data!");
            e.printStackTrace();
        }
        WekaInstanceBuffer buffer = new WekaInstanceBuffer();
        buffer.setOperation(WekaInstanceBuffer.Operation.INSTANCES_TO_INSTANCE);
        buffer.setUp();
        buffer.input(new Token((Object)data));
        buffer.execute();
        int count = 0;
        for (int i = 0; i < data.numInstances() && buffer.hasPendingOutput(); ++i) {
            Instance inst = (Instance)buffer.output().getPayload();
            WekaInstanceBufferTest.assertEquals((String)("Data row #" + (i + 1) + " differs"), (String)data.instance(i).toString(), (String)inst.toString());
            ++count;
        }
        buffer.wrapUp();
        buffer.cleanUp();
        WekaInstanceBufferTest.assertEquals((String)"Number of rows differ", (int)data.numInstances(), (int)count);
    }

    public static Test suite() {
        return new TestSuite(WekaInstanceBufferTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaInstanceBufferTest.runTest((Test)WekaInstanceBufferTest.suite());
    }
}

