/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.Counting;
import adams.flow.condition.bool.Not;
import adams.flow.control.Continue;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaStoreInstance;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ArffLoader;

public class WekaStoreInstanceTest
extends AbstractFlowTest {
    public WekaStoreInstanceTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(WekaStoreInstanceTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp1 = new AbstractActor[5];
            FileSupplier tmp2 = new FileSupplier();
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("files");
            tmp2.setFiles(new PlaceholderFile[]{new TmpFile("bolts.arff")});
            tmp1[0] = tmp2;
            WekaFileReader tmp4 = new WekaFileReader();
            argOption = (AbstractArgumentOption)tmp4.getOptionManager().findByProperty("customLoader");
            ArffLoader tmp6 = new ArffLoader();
            tmp4.setCustomLoader((AbstractFileLoader)tmp6);
            argOption = (AbstractArgumentOption)tmp4.getOptionManager().findByProperty("outputType");
            tmp4.setOutputType((WekaFileReader.OutputType)argOption.valueOf("INCREMENTAL"));
            tmp1[1] = tmp4;
            Continue tmp8 = new Continue();
            argOption = (AbstractArgumentOption)tmp8.getOptionManager().findByProperty("condition");
            Not tmp10 = new Not();
            argOption = (AbstractArgumentOption)tmp10.getOptionManager().findByProperty("condition");
            Counting tmp12 = new Counting();
            argOption = (AbstractArgumentOption)tmp12.getOptionManager().findByProperty("maximum");
            tmp12.setMaximum(((Integer)argOption.valueOf("3")).intValue());
            tmp10.setCondition((BooleanCondition)tmp12);
            tmp8.setCondition((BooleanCondition)tmp10);
            tmp1[2] = tmp8;
            WekaStoreInstance tmp14 = new WekaStoreInstance();
            argOption = (AbstractArgumentOption)tmp14.getOptionManager().findByProperty("dataset");
            tmp14.setDataset((StorageName)argOption.valueOf("dataset"));
            tmp1[3] = tmp14;
            DumpFile tmp16 = new DumpFile();
            argOption = (AbstractArgumentOption)tmp16.getOptionManager().findByProperty("outputFile");
            tmp16.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
            tmp16.setAppend(true);
            tmp1[4] = tmp16;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            WekaStoreInstanceTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        WekaStoreInstanceTest.runTest((Test)WekaStoreInstanceTest.suite());
    }
}

